/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.DefaultAuthHandler;
import HTTPClient.GlobalConstants;
import HTTPClient.HashVerifier;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.MD5;
import HTTPClient.ParseException;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;

class VerifyDigest
implements HashVerifier,
GlobalConstants {
    private String HA1;
    private String nonce;
    private String method;
    private String uri;
    private String hdr;
    private RoResponse resp;

    public VerifyDigest(String HA1, String nonce, String method, String uri, String hdr, RoResponse resp) {
        this.HA1 = HA1;
        this.nonce = nonce;
        this.method = method;
        this.uri = uri;
        this.hdr = hdr;
        this.resp = resp;
    }

    @Override
    public void verifyHash(byte[] hash, long len) throws IOException {
        Vector pai;
        String auth_info = this.resp.getHeader(this.hdr);
        if (auth_info == null) {
            auth_info = this.resp.getTrailer(this.hdr);
        }
        if (auth_info == null) {
            return;
        }
        try {
            pai = Util.parseHeader(auth_info);
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
        HttpHeaderElement elem = Util.getElement(pai, "digest");
        if (elem == null || elem.getValue() == null) {
            return;
        }
        byte[] digest = DefaultAuthHandler.unHex(elem.getValue());
        String entity_info = MD5.hexDigest(this.uri + ":" + VerifyDigest.header_val("Content-Type", this.resp) + ":" + VerifyDigest.header_val("Content-Length", this.resp) + ":" + VerifyDigest.header_val("Content-Encoding", this.resp) + ":" + VerifyDigest.header_val("Last-Modified", this.resp) + ":" + VerifyDigest.header_val("Expires", this.resp));
        hash = MD5.digest(this.HA1 + ":" + this.nonce + ":" + this.method + ":" + VerifyDigest.header_val("Date", this.resp) + ":" + entity_info + ":" + MD5.toHex(hash));
        for (int idx = 0; idx < hash.length; ++idx) {
            if (hash[idx] == digest[idx]) continue;
            throw new IOException("MD5-Digest mismatch: expected " + DefaultAuthHandler.hex(digest) + " but calculated " + DefaultAuthHandler.hex(hash));
        }
        Log.write(8, "Auth:  digest from " + this.hdr + " successfully verified");
    }

    private static final String header_val(String hdr_name, RoResponse resp) throws IOException {
        String hdr = resp.getHeader(hdr_name);
        String tlr = resp.getTrailer(hdr_name);
        return hdr != null ? hdr : (tlr != null ? tlr : "");
    }
}

