/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwtwidgets.server.spring.ReflectionUtils;
import org.gwtwidgets.server.spring.ServletUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.ServletContextAware;

public class GWTRPCServiceExporter
extends RemoteServiceServlet
implements HttpRequestHandler,
InitializingBean,
ServletContextAware {
    private static final long serialVersionUID = 4424267386489335423L;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Class[] serviceInterfaces;
    protected Object service = this;
    protected ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public static HttpServletRequest getRequest() {
        return ServletUtils.getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtils.getResponse();
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
        this.logger.trace((Object)("Serialised RPC response: [" + serializedResponse + "]"));
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
        this.logger.trace((Object)("Serialised RPC request: [" + serializedRequest + "]"));
    }

    public String processCall(String payload) throws SerializationException {
        try {
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload);
            Method targetMethod = ReflectionUtils.getRPCMethod(this.service, this.serviceInterfaces, rpcRequest.getMethod());
            Object[] targetParameters = rpcRequest.getParameters();
            try {
                Object result = targetMethod.invoke(this.service, targetParameters);
                String encodedResult = RPC.encodeResponseForSuccess((Method)rpcRequest.getMethod(), (Object)result);
                return encodedResult;
            }
            catch (IllegalArgumentException e) {
                SecurityException securityException = new SecurityException("Blocked attempt to invoke method " + targetMethod);
                securityException.initCause(e);
                throw securityException;
            }
            catch (IllegalAccessException e) {
                SecurityException securityException = new SecurityException("Blocked attempt to access inaccessible method " + targetMethod + (this.service != null ? " on service " + this.service : ""));
                securityException.initCause(e);
                throw securityException;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof IsSerializable)) {
                    this.logger.warn((Object)e);
                }
                String failurePayload = RPC.encodeResponseForFailure((Method)rpcRequest.getMethod(), (Throwable)cause);
                return failurePayload;
            }
        }
        catch (IncompatibleRemoteServiceException e) {
            this.logger.warn((Object)e.getMessage());
            return RPC.encodeResponseForFailure(null, (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setService(Object service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ServletUtils.setRequest(request);
            ServletUtils.setResponse(response);
            this.doPost(request, response);
        }
        finally {
            ServletUtils.setRequest(null);
            ServletUtils.setResponse(null);
        }
    }

    public void setServiceInterfaces(Class[] serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.service == null) {
            throw new Exception("You must specify a service object.");
        }
        if (this.serviceInterfaces == null) {
            this.logger.debug((Object)"Discovering service interfaces");
            this.serviceInterfaces = ReflectionUtils.getExposedInterfaces(this.service.getClass());
            if (this.serviceInterfaces.length == 0) {
                this.logger.warn((Object)"The specified service does neither implement RemoteService nor were any service interfaces specified. RPC access to *all* object methods is allowed.");
            }
        }
    }

    public Object getService() {
        return this.service;
    }
}

