/*
 * Copyright 2007 Robert Hanson <iamroberthanson AT gmail.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gwtwidgets.client.ui.canvas.impl;

import org.gwtwidgets.client.ui.canvas.Canvas;
import org.gwtwidgets.client.ui.canvas.Font;
import org.gwtwidgets.client.ui.canvas.FontLoadListener;

/**
 * Factory for canvas instances. Each canvas implementation should also provide a corresponding
 * factory implementation and register its type for the browser it was concieved for in
 * <code>WidgetLibrary.gwt.xml</code>.
 * @author George Georgovassilis g.georgovassilis[at]gmail.com
 *
 */
public abstract class CanvasFactory {

	/**
	 * Return a canvas implementation for the current browser
	 * @param width
	 * @param height
	 * @return
	 */
	public abstract Canvas create(int width, int height);
	
	/**
	 * Get a font object for use with a canvas. This method is asynchronous and may
	 * issue non blocking requests to the server. Depending on the implementation,
	 * {@link Font} objects may be returned that are not yet initialised and an invocation of
	 * <code>onLoad</code> must be expected prior to using the font. Again, depending on the
	 * implementation, cached instanced may be returned immediately, and the <code>onLoad</code>
	 * listener will be invoked before returning the font object. 
	 * @param bitmapPath Path to the font bitmap.
	 * @param descriptionPath Path to the font descriptor 
	 * @param listener Optional listener to invoke after font has been instantiated or when an error occured.
	 * @return Font
	 */
	public abstract Font getFont(String bitmapPath, String descriptionPath, FontLoadListener listener);

}
