/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import net.sf.jasperreports.charts.ChartVisitorFactory;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.type.ChartTypeEnum;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseChart
extends JRBaseElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_CHART_TYPE_NOT_SUPPORTED = "charts.chart.type.not.supported";
    public static final String PROPERTY_LEGEND_BACKGROUND_COLOR = "legendBackgroundColor";
    public static final String PROPERTY_LEGEND_COLOR = "legendColor";
    public static final String PROPERTY_LEGEND_POSITION = "legendPosition";
    public static final String PROPERTY_SHOW_LEGEND = "isShowLegend";
    public static final String PROPERTY_SUBTITLE_COLOR = "subtitleColor";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_TITLE_POSITION = "titlePosition";
    public static final String PROPERTY_RENDER_TYPE = "renderType";
    public static final String PROPERTY_THEME = "theme";
    protected ChartTypeEnum chartType;
    protected Boolean showLegend;
    protected EvaluationTimeEnum evaluationTime;
    protected String linkType;
    protected String linkTarget;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected Color titleColor;
    protected Color subtitleColor;
    protected Color legendColor;
    protected Color legendBackgroundColor;
    protected EdgeEnum legendPosition;
    protected EdgeEnum titlePosition;
    protected String renderType;
    protected String theme;
    protected JRLineBox lineBox;
    protected JRFont titleFont;
    protected JRFont subtitleFont;
    protected JRFont legendFont;
    protected String customizerClass;
    protected String evaluationGroup;
    protected JRExpression titleExpression;
    protected JRExpression subtitleExpression;
    protected JRExpression anchorNameExpression;
    protected JRExpression bookmarkLevelExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected JRChartDataset dataset;
    protected JRChartPlot plot;
    protected int bookmarkLevel = 0;

    protected JRBaseChart(JRChart chart, ChartsBaseObjectFactory factory) {
        super((JRElement)chart, factory.getParent());
        JRBaseObjectFactory parentFactory = factory.getParent();
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case AREA: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case BAR: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case BAR3D: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                JRBar3DPlot depPlot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                this.plot = depPlot;
                break;
            }
            case BUBBLE: {
                this.dataset = factory.getXyzDataset((JRXyzDataset)chart.getDataset());
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case CANDLESTICK: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case HIGHLOW: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case LINE: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case METER: {
                this.dataset = factory.getValueDataset((JRValueDataset)chart.getDataset());
                this.plot = factory.getMeterPlot((JRMeterPlot)chart.getPlot());
                break;
            }
            case MULTI_AXIS: {
                this.dataset = null;
                this.plot = factory.getMultiAxisPlot((JRMultiAxisPlot)chart.getPlot());
                break;
            }
            case PIE: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case PIE3D: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                JRPie3DPlot depPlot = factory.getPie3DPlot((JRPie3DPlot)chart.getPlot());
                this.plot = depPlot;
                break;
            }
            case SCATTER: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case STACKEDBAR: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case STACKEDBAR3D: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                JRBar3DPlot depPlot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                this.plot = depPlot;
                break;
            }
            case THERMOMETER: {
                this.dataset = factory.getValueDataset((JRValueDataset)chart.getDataset());
                this.plot = factory.getThermometerPlot((JRThermometerPlot)chart.getPlot());
                break;
            }
            case TIMESERIES: {
                this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case XYAREA: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case XYBAR: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                        break;
                    }
                    case 5: {
                        this.dataset = factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset());
                        break;
                    }
                    case 3: {
                        this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                        break;
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case XYLINE: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case STACKEDAREA: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case GANTT: {
                this.dataset = factory.getGanttDataset((JRGanttDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CHART_TYPE_NOT_SUPPORTED, new Object[]{this.chartType});
            }
        }
        this.showLegend = chart.getShowLegend();
        this.evaluationTime = chart.getEvaluationTime();
        this.linkType = chart.getLinkType();
        this.linkTarget = chart.getLinkTarget();
        this.titlePosition = chart.getTitlePosition();
        this.titleColor = chart.getOwnTitleColor();
        this.subtitleColor = chart.getOwnSubtitleColor();
        this.legendColor = chart.getOwnLegendColor();
        this.legendBackgroundColor = chart.getOwnLegendBackgroundColor();
        this.legendPosition = chart.getLegendPosition();
        this.renderType = chart.getRenderType();
        this.theme = chart.getTheme();
        this.titleFont = parentFactory.getFont((JRStyleContainer)this, chart.getTitleFont());
        this.subtitleFont = parentFactory.getFont((JRStyleContainer)this, chart.getSubtitleFont());
        this.legendFont = parentFactory.getFont((JRStyleContainer)this, chart.getLegendFont());
        this.evaluationGroup = chart.getEvaluationGroup();
        this.titleExpression = parentFactory.getExpression(chart.getTitleExpression());
        this.subtitleExpression = parentFactory.getExpression(chart.getSubtitleExpression());
        this.bookmarkLevelExpression = parentFactory.getExpression(chart.getBookmarkLevelExpression());
        this.anchorNameExpression = parentFactory.getExpression(chart.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = parentFactory.getExpression(chart.getHyperlinkReferenceExpression());
        this.hyperlinkWhenExpression = parentFactory.getExpression(chart.getHyperlinkWhenExpression());
        this.hyperlinkAnchorExpression = parentFactory.getExpression(chart.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = parentFactory.getExpression(chart.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = parentFactory.getExpression(chart.getHyperlinkTooltipExpression());
        this.bookmarkLevel = chart.getBookmarkLevel();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters((JRHyperlink)chart, (JRBaseObjectFactory)parentFactory);
        this.customizerClass = chart.getCustomizerClass();
        this.lineBox = chart.getLineBox().clone((JRBoxContainer)this);
    }

    @Override
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    @Override
    public void setShowLegend(Boolean isShowLegend) {
        Boolean old = this.showLegend;
        this.showLegend = isShowLegend;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_LEGEND, (Object)old, (Object)this.showLegend);
    }

    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    @Override
    public EdgeEnum getTitlePosition() {
        return this.titlePosition;
    }

    @Override
    public void setTitlePosition(EdgeEnum titlePosition) {
        EdgeEnum old = this.titlePosition;
        this.titlePosition = titlePosition;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_POSITION, (Object)old, (Object)this.titlePosition);
    }

    @Override
    public Color getTitleColor() {
        return this.getChartsStyleResolver().getTitleColor(this);
    }

    @Override
    public Color getOwnTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setTitleColor(Color titleColor) {
        Color old = this.titleColor;
        this.titleColor = titleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_COLOR, (Object)old, (Object)this.titleColor);
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    @Override
    public Color getOwnSubtitleColor() {
        return this.subtitleColor;
    }

    @Override
    public Color getSubtitleColor() {
        return this.getChartsStyleResolver().getSubtitleColor(this);
    }

    @Override
    public void setSubtitleColor(Color subtitleColor) {
        Color old = this.subtitleColor;
        this.subtitleColor = subtitleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_COLOR, (Object)old, (Object)this.subtitleColor);
    }

    @Override
    public Color getLegendBackgroundColor() {
        return this.getChartsStyleResolver().getLegendBackgroundColor(this);
    }

    @Override
    public Color getOwnLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @Override
    public Color getOwnLegendColor() {
        return this.legendColor;
    }

    @Override
    public Color getLegendColor() {
        return this.getChartsStyleResolver().getLegendColor(this);
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    @Override
    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        Color old = this.legendBackgroundColor;
        this.legendBackgroundColor = legendBackgroundColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_BACKGROUND_COLOR, (Object)old, (Object)this.legendBackgroundColor);
    }

    @Override
    public void setLegendColor(Color legendColor) {
        Color old = this.legendColor;
        this.legendColor = legendColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_COLOR, (Object)old, (Object)this.legendColor);
    }

    @Override
    public EdgeEnum getLegendPosition() {
        return this.legendPosition;
    }

    @Override
    public void setLegendPosition(EdgeEnum legendPosition) {
        EdgeEnum old = this.legendPosition;
        this.legendPosition = legendPosition;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_POSITION, (Object)old, (Object)this.legendPosition);
    }

    public HyperlinkTypeEnum getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType((JRHyperlink)this);
    }

    public HyperlinkTargetEnum getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget((JRHyperlink)this);
    }

    @Override
    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public JRExpression getBookmarkLevelExpression() {
        return this.bookmarkLevelExpression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public JRChartDataset getDataset() {
        return this.chartType == ChartTypeEnum.MULTI_AXIS ? null : this.dataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    @Override
    public ChartTypeEnum getChartType() {
        return this.chartType;
    }

    @Override
    public String getRenderType() {
        return this.renderType;
    }

    @Override
    public void setRenderType(String renderType) {
        String old = this.renderType;
        this.renderType = renderType;
        this.getEventSupport().firePropertyChange(PROPERTY_RENDER_TYPE, (Object)old, (Object)this.renderType);
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(String theme) {
        String old = this.theme;
        this.theme = theme;
        this.getEventSupport().firePropertyChange(PROPERTY_THEME, (Object)old, (Object)this.theme);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        new ChartsExpressionCollector(collector).collect(this);
    }

    public void visit(JRVisitor visitor) {
        ChartVisitorFactory.getInstance().getChartVisitor(visitor).visitChart(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public ModeEnum getMode() {
        return this.getStyleResolver().getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public Object clone() {
        JRBaseChart clone = (JRBaseChart)super.clone();
        clone.lineBox = this.lineBox.clone((JRBoxContainer)clone);
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.titleFont = (JRFont)JRCloneUtils.nullSafeClone((JRCloneable)((JRBaseFont)this.titleFont));
        clone.subtitleFont = (JRFont)JRCloneUtils.nullSafeClone((JRCloneable)((JRBaseFont)this.subtitleFont));
        clone.legendFont = (JRFont)JRCloneUtils.nullSafeClone((JRCloneable)((JRBaseFont)this.legendFont));
        clone.titleExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.titleExpression);
        clone.subtitleExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.subtitleExpression);
        clone.anchorNameExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.anchorNameExpression);
        clone.bookmarkLevelExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.bookmarkLevelExpression);
        clone.hyperlinkReferenceExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.hyperlinkTooltipExpression);
        clone.dataset = (JRChartDataset)JRCloneUtils.nullSafeClone((JRCloneable)this.dataset);
        clone.plot = this.plot == null ? null : (JRChartPlot)this.plot.clone(clone);
        return clone;
    }
}

