/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import net.sf.jasperreports.charts.ChartVisitor;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.type.ChartTypeEnum;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JRVerifierVisitor;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class ChartsVerifier
implements ChartVisitor {
    private final JRVerifier parent;

    public ChartsVerifier(JRVerifierVisitor visitor) {
        this.parent = visitor.getVerifier();
    }

    @Override
    public void visitChart(JRChart chart) {
        JRChartDataset dataset;
        this.parent.verifyReportElement((JRElement)chart);
        if (chart.getEvaluationTime() == EvaluationTimeEnum.AUTO) {
            this.parent.addBrokenRule("Charts do not support Auto evaluation time.", (Object)chart);
        }
        if ((dataset = chart.getDataset()) == null) {
            if (chart.getChartType() != ChartTypeEnum.MULTI_AXIS) {
                this.parent.addBrokenRule("Chart dataset missing.", (Object)chart);
            }
        } else {
            dataset.validate(this);
        }
    }

    public void verify(JRCategoryDataset dataset) {
        this.parent.verifyElementDataset((JRElementDataset)dataset);
        JRCategorySeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRCategorySeries series) {
        this.parent.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRPieDataset dataset) {
        this.parent.verifyElementDataset((JRElementDataset)dataset);
        JRPieSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
        this.parent.verifyHyperlink(dataset.getOtherSectionHyperlink());
    }

    protected void verify(JRPieSeries series) {
        this.parent.verifyHyperlink(series.getSectionHyperlink());
    }

    public void verify(JRHighLowDataset dataset) {
        this.parent.verifyElementDataset((JRElementDataset)dataset);
        this.parent.verifyHyperlink(dataset.getItemHyperlink());
    }

    public void verify(JRTimePeriodDataset dataset) {
        this.parent.verifyElementDataset((JRElementDataset)dataset);
        JRTimePeriodSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRTimePeriodSeries series) {
        this.parent.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRTimeSeriesDataset dataset) {
        this.parent.verifyElementDataset((JRElementDataset)dataset);
        JRTimeSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRTimeSeries series) {
        this.parent.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRValueDataset dataset) {
    }

    public void verify(JRXyDataset dataset) {
        this.parent.verifyElementDataset((JRElementDataset)dataset);
        JRXySeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRXySeries series) {
        this.parent.verifyHyperlink(series.getItemHyperlink());
    }

    protected void verify(JRGanttSeries series) {
        this.parent.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRXyzDataset dataset) {
        this.parent.verifyElementDataset((JRElementDataset)dataset);
        JRXyzSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    public void verify(JRGanttDataset dataset) {
        this.parent.verifyElementDataset((JRElementDataset)dataset);
        JRGanttSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRXyzSeries series) {
        this.parent.verifyHyperlink(series.getItemHyperlink());
    }
}

