/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseMeterPlot;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;

public class JRDesignMeterPlot
extends JRBaseMeterPlot {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DATA_RANGE = "dataRange";
    public static final String PROPERTY_METER_ANGLE = "meterAngle";
    public static final String PROPERTY_METER_BACKGROUND_COLOR = "meterBackgroundColor";
    public static final String PROPERTY_NEEDLE_COLOR = "needleColor";
    public static final String PROPERTY_SHAPE = "shape";
    public static final String PROPERTY_TICK_COLOR = "tickColor";
    public static final String PROPERTY_TICK_COUNT = "tickCount";
    public static final String PROPERTY_TICK_INTERVAL = "tickInterval";
    public static final String PROPERTY_UNITS = "units";
    public static final String PROPERTY_VALUE_DISPLAY = "valueDisplay";
    public static final String PROPERTY_INTERVALS = "intervals";
    public static final String PROPERTY_TICK_LABEL_FONT = "tickLabelFont";

    @JsonCreator
    private JRDesignMeterPlot() {
        this((JRChartPlot)null, (JRChart)null);
    }

    public JRDesignMeterPlot(JRChartPlot plot, JRChart chart) {
        super(plot, chart);
    }

    public void setDataRange(JRDataRange dataRange) throws JRException {
        JRDataRange old = this.dataRange;
        this.dataRange = dataRange;
        this.getEventSupport().firePropertyChange(PROPERTY_DATA_RANGE, (Object)old, (Object)this.dataRange);
    }

    public void setValueDisplay(JRValueDisplay valueDisplay) {
        JRValueDisplay old = this.valueDisplay;
        this.valueDisplay = new JRBaseValueDisplay(valueDisplay, this.getChart());
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE_DISPLAY, (Object)old, (Object)this.valueDisplay);
    }

    public void setShape(MeterShapeEnum shape) throws JRException {
        MeterShapeEnum old = this.shape;
        this.shape = shape;
        this.getEventSupport().firePropertyChange(PROPERTY_SHAPE, (Object)old, (Object)this.shape);
    }

    public void addInterval(JRMeterInterval interval) {
        this.intervals.add(interval);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_INTERVALS, (Object)interval, this.intervals.size() - 1);
    }

    public void clearIntervals() {
        this.setIntervals(null);
    }

    @JsonSetter
    public void setIntervals(Collection<JRMeterInterval> intervals) {
        ArrayList old = new ArrayList(this.intervals);
        this.intervals.clear();
        if (intervals != null) {
            this.intervals.addAll(intervals);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_INTERVALS, old, (Object)this.intervals);
    }

    public void setMeterAngle(Integer meterAngle) {
        Integer old = this.meterAngle;
        this.meterAngle = meterAngle;
        this.getEventSupport().firePropertyChange(PROPERTY_METER_ANGLE, (Object)old, (Object)this.meterAngle);
    }

    public void setUnits(String units) {
        String old = this.units;
        this.units = units;
        this.getEventSupport().firePropertyChange(PROPERTY_UNITS, (Object)old, (Object)this.units);
    }

    public void setTickInterval(Double tickInterval) {
        Double old = this.tickInterval;
        this.tickInterval = tickInterval;
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_INTERVAL, (Object)old, (Object)this.tickInterval);
    }

    @JsonSetter(value="meterColor")
    public void setMeterBackgroundColor(Color meterBackgroundColor) {
        Color old = this.meterBackgroundColor;
        this.meterBackgroundColor = meterBackgroundColor;
        this.getEventSupport().firePropertyChange(PROPERTY_METER_BACKGROUND_COLOR, (Object)old, (Object)this.meterBackgroundColor);
    }

    public void setNeedleColor(Color needleColor) {
        Color old = this.needleColor;
        this.needleColor = needleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_NEEDLE_COLOR, (Object)old, (Object)this.needleColor);
    }

    public void setTickColor(Color tickColor) {
        Color old = this.tickColor;
        this.tickColor = tickColor;
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_COLOR, (Object)old, (Object)this.tickColor);
    }

    public void setTickCount(Integer tickCount) {
        Integer old = this.tickCount;
        this.tickCount = tickCount;
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_COUNT, (Object)old, (Object)this.tickCount);
    }

    public void setTickLabelFont(JRFont tickLabelFont) {
        JRFont old = this.tickLabelFont;
        this.tickLabelFont = tickLabelFont;
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_LABEL_FONT, (Object)old, (Object)this.tickLabelFont);
    }
}

