/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import net.sf.jasperreports.charts.ChartCopyObjectFactory;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.base.ChartCopyBaseObjectFactory;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartPlot;
import net.sf.jasperreports.charts.base.JRBaseItemLabel;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseBarPlot
extends JRBaseChartPlot
implements JRBarPlot {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_SHOW_LABELS = "isShowLabels";
    public static final String PROPERTY_SHOW_TICK_LABELS = "isShowTickLabels";
    public static final String PROPERTY_SHOW_TICK_MARKS = "isShowTickMarks";
    protected JRExpression categoryAxisLabelExpression;
    protected JRFont categoryAxisLabelFont;
    protected Color categoryAxisLabelColor;
    protected JRFont categoryAxisTickLabelFont;
    protected Color categoryAxisTickLabelColor;
    protected String categoryAxisTickLabelMask;
    protected Boolean categoryAxisVerticalTickLabels;
    protected Color categoryAxisLineColor;
    protected JRExpression valueAxisLabelExpression;
    protected JRExpression rangeAxisMinValueExpression;
    protected JRExpression rangeAxisMaxValueExpression;
    protected JRExpression domainAxisMinValueExpression;
    protected JRExpression domainAxisMaxValueExpression;
    protected JRFont valueAxisLabelFont;
    protected Color valueAxisLabelColor;
    protected JRFont valueAxisTickLabelFont;
    protected Color valueAxisTickLabelColor;
    protected String valueAxisTickLabelMask;
    protected Boolean valueAxisVerticalTickLabels;
    protected Color valueAxisLineColor;
    protected Boolean showTickMarks;
    protected Boolean showTickLabels;
    protected Boolean showLabels;
    protected JRItemLabel itemLabel;

    public JRBaseBarPlot(JRChartPlot plot, JRChart chart) {
        this(plot, chart, ChartCopyBaseObjectFactory.instance());
    }

    protected JRBaseBarPlot(JRChartPlot plot, JRChart chart, ChartCopyObjectFactory copyObjectFactory) {
        super(plot, chart);
        JRBarPlot barPlot;
        JRBarPlot jRBarPlot = barPlot = plot instanceof JRBarPlot ? (JRBarPlot)plot : null;
        if (barPlot == null) {
            this.itemLabel = copyObjectFactory.copyItemLabel(null, chart);
        } else {
            this.categoryAxisLabelFont = barPlot.getCategoryAxisLabelFont();
            this.categoryAxisTickLabelFont = barPlot.getCategoryAxisTickLabelFont();
            this.valueAxisLabelFont = barPlot.getValueAxisLabelFont();
            this.valueAxisTickLabelFont = barPlot.getValueAxisTickLabelFont();
            this.itemLabel = copyObjectFactory.copyItemLabel(barPlot.getItemLabel(), chart);
        }
    }

    public JRBaseBarPlot(JRBarPlot barPlot, ChartsBaseObjectFactory factory) {
        super((JRChartPlot)barPlot, factory);
        JRBaseObjectFactory parentFactory = factory.getParent();
        this.showTickMarks = barPlot.getShowTickMarks();
        this.showTickLabels = barPlot.getShowTickLabels();
        this.showLabels = barPlot.getShowLabels();
        this.categoryAxisLabelExpression = parentFactory.getExpression(barPlot.getCategoryAxisLabelExpression());
        this.categoryAxisLabelFont = parentFactory.getFont((JRStyleContainer)this.chart, barPlot.getCategoryAxisLabelFont());
        this.categoryAxisLabelColor = barPlot.getOwnCategoryAxisLabelColor();
        this.categoryAxisTickLabelFont = parentFactory.getFont((JRStyleContainer)this.chart, barPlot.getCategoryAxisTickLabelFont());
        this.categoryAxisTickLabelColor = barPlot.getOwnCategoryAxisTickLabelColor();
        this.categoryAxisTickLabelMask = barPlot.getCategoryAxisTickLabelMask();
        this.categoryAxisVerticalTickLabels = barPlot.getCategoryAxisVerticalTickLabels();
        this.categoryAxisLineColor = barPlot.getOwnCategoryAxisLineColor();
        this.labelRotation = barPlot.getCategoryAxisTickLabelRotation();
        this.valueAxisLabelExpression = parentFactory.getExpression(barPlot.getValueAxisLabelExpression());
        this.domainAxisMinValueExpression = parentFactory.getExpression(barPlot.getDomainAxisMinValueExpression());
        this.domainAxisMaxValueExpression = parentFactory.getExpression(barPlot.getDomainAxisMaxValueExpression());
        this.rangeAxisMinValueExpression = parentFactory.getExpression(barPlot.getRangeAxisMinValueExpression());
        this.rangeAxisMaxValueExpression = parentFactory.getExpression(barPlot.getRangeAxisMaxValueExpression());
        this.valueAxisLabelFont = parentFactory.getFont((JRStyleContainer)this.chart, barPlot.getValueAxisLabelFont());
        this.valueAxisLabelColor = barPlot.getOwnValueAxisLabelColor();
        this.valueAxisTickLabelFont = parentFactory.getFont((JRStyleContainer)this.chart, barPlot.getValueAxisTickLabelFont());
        this.valueAxisTickLabelColor = barPlot.getOwnValueAxisTickLabelColor();
        this.valueAxisTickLabelMask = barPlot.getValueAxisTickLabelMask();
        this.valueAxisVerticalTickLabels = barPlot.getValueAxisVerticalTickLabels();
        this.valueAxisLineColor = barPlot.getOwnValueAxisLineColor();
        this.itemLabel = new JRBaseItemLabel(barPlot.getItemLabel(), factory);
    }

    @Override
    public JRExpression getCategoryAxisLabelExpression() {
        return this.categoryAxisLabelExpression;
    }

    @Override
    public JRFont getCategoryAxisLabelFont() {
        return this.categoryAxisLabelFont;
    }

    @Override
    public Color getCategoryAxisLabelColor() {
        return this.getStyleResolver().getCategoryAxisLabelColor(this, this);
    }

    @Override
    public Color getOwnCategoryAxisLabelColor() {
        return this.categoryAxisLabelColor;
    }

    @Override
    public JRFont getCategoryAxisTickLabelFont() {
        return this.categoryAxisTickLabelFont;
    }

    @Override
    public Color getCategoryAxisTickLabelColor() {
        return this.getStyleResolver().getCategoryAxisTickLabelColor(this, this);
    }

    @Override
    public Color getOwnCategoryAxisTickLabelColor() {
        return this.categoryAxisTickLabelColor;
    }

    @Override
    public String getCategoryAxisTickLabelMask() {
        return this.categoryAxisTickLabelMask;
    }

    @Override
    public Boolean getCategoryAxisVerticalTickLabels() {
        return this.categoryAxisVerticalTickLabels;
    }

    @Override
    public Double getCategoryAxisTickLabelRotation() {
        return this.labelRotation;
    }

    @Override
    public void setCategoryAxisTickLabelRotation(Double labelRotation) {
        Double old = this.labelRotation;
        this.labelRotation = labelRotation;
        this.getEventSupport().firePropertyChange("categoryAxisTickLabelRotation", (Object)old, (Object)this.labelRotation);
    }

    @Override
    public Color getCategoryAxisLineColor() {
        return this.getStyleResolver().getCategoryAxisLineColor(this, this);
    }

    @Override
    public Color getOwnCategoryAxisLineColor() {
        return this.categoryAxisLineColor;
    }

    @Override
    public JRExpression getValueAxisLabelExpression() {
        return this.valueAxisLabelExpression;
    }

    @Override
    public JRExpression getDomainAxisMinValueExpression() {
        return this.domainAxisMinValueExpression;
    }

    @Override
    public JRExpression getDomainAxisMaxValueExpression() {
        return this.domainAxisMaxValueExpression;
    }

    @Override
    public JRExpression getRangeAxisMinValueExpression() {
        return this.rangeAxisMinValueExpression;
    }

    @Override
    public JRExpression getRangeAxisMaxValueExpression() {
        return this.rangeAxisMaxValueExpression;
    }

    @Override
    public JRFont getValueAxisLabelFont() {
        return this.valueAxisLabelFont;
    }

    @Override
    public Color getValueAxisLabelColor() {
        return this.getStyleResolver().getValueAxisLabelColor(this, this);
    }

    @Override
    public Color getOwnValueAxisLabelColor() {
        return this.valueAxisLabelColor;
    }

    @Override
    public JRFont getValueAxisTickLabelFont() {
        return this.valueAxisTickLabelFont;
    }

    @Override
    public Color getValueAxisTickLabelColor() {
        return this.getStyleResolver().getValueAxisTickLabelColor(this, this);
    }

    @Override
    public Color getOwnValueAxisTickLabelColor() {
        return this.valueAxisTickLabelColor;
    }

    @Override
    public String getValueAxisTickLabelMask() {
        return this.valueAxisTickLabelMask;
    }

    @Override
    public Boolean getValueAxisVerticalTickLabels() {
        return this.valueAxisVerticalTickLabels;
    }

    @Override
    public Color getValueAxisLineColor() {
        return this.getStyleResolver().getValueAxisLineColor(this, this);
    }

    @Override
    public Color getOwnValueAxisLineColor() {
        return this.valueAxisLineColor;
    }

    @Override
    public Boolean getShowLabels() {
        return this.showLabels;
    }

    @Override
    public JRItemLabel getItemLabel() {
        return this.itemLabel;
    }

    @Override
    public void setShowLabels(Boolean showLabels) {
        Boolean old = this.showLabels;
        this.showLabels = showLabels;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_LABELS, (Object)old, (Object)this.showLabels);
    }

    @Override
    public Boolean getShowTickMarks() {
        return this.showTickMarks;
    }

    @Override
    public void setShowTickMarks(Boolean isShowTickMarks) {
        Boolean old = this.showTickMarks;
        this.showTickMarks = isShowTickMarks;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_TICK_MARKS, (Object)old, (Object)this.showTickMarks);
    }

    @Override
    public Boolean getShowTickLabels() {
        return this.showTickLabels;
    }

    @Override
    public void setShowTickLabels(Boolean showTickLabels) {
        Boolean old = this.showTickLabels;
        this.showTickLabels = showTickLabels;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_TICK_LABELS, (Object)old, (Object)this.showTickLabels);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public Object clone(JRChart parentChart) {
        JRBaseBarPlot clone = (JRBaseBarPlot)super.clone(parentChart);
        clone.categoryAxisLabelExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.categoryAxisLabelExpression);
        clone.valueAxisLabelExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.valueAxisLabelExpression);
        clone.domainAxisMinValueExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.domainAxisMinValueExpression);
        clone.domainAxisMaxValueExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.domainAxisMaxValueExpression);
        clone.rangeAxisMinValueExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.rangeAxisMinValueExpression);
        clone.rangeAxisMaxValueExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.rangeAxisMaxValueExpression);
        clone.itemLabel = this.itemLabel == null ? null : this.itemLabel.clone(parentChart);
        return clone;
    }
}

