/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.base.JRBaseMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignChart;

public class JRDesignMultiAxisPlot
extends JRBaseMultiAxisPlot {
    public static final String PROPERTY_CHART = "chart";
    public static final String PROPERTY_AXES = "axes";
    private static final long serialVersionUID = 10200L;

    @JsonCreator
    private JRDesignMultiAxisPlot() {
        this((JRChartPlot)null, (JRChart)null);
    }

    public JRDesignMultiAxisPlot(JRChartPlot multiAxisPlot, JRChart chart) {
        super(multiAxisPlot, chart);
    }

    @JsonSetter
    private void setAxes(List<JRChartAxis> axes) {
        if (axes != null) {
            for (JRChartAxis axis : axes) {
                this.addAxis(axis);
            }
        }
    }

    public void addAxis(JRChartAxis axis) {
        this.axes.add(axis);
        if (this.axes.size() == 1) {
            ((JRDesignChart)this.getChart()).setDataset(axis.getChart().getDataset());
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_AXES, (Object)axis, this.axes.size() - 1);
    }

    public void addAxis(int index, JRChartAxis axis) {
        this.axes.add(index, axis);
        if (this.axes.size() == 1) {
            ((JRDesignChart)this.getChart()).setDataset(axis.getChart().getDataset());
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_AXES, (Object)axis, index);
    }

    public JRChartAxis removeAxis(JRChartAxis axis) {
        int idx;
        if (axis != null && (idx = this.axes.indexOf(axis)) >= 0) {
            this.axes.remove(idx);
            ((JRDesignChart)this.getChart()).setDataset(axis.getChart().getDataset());
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_AXES, (Object)axis, idx);
        }
        return axis;
    }

    public void clearAxes() {
        ArrayList tmpList = new ArrayList(this.axes);
        Iterator it = tmpList.iterator();
        while (it.hasNext()) {
            this.removeAxis((JRChartAxis)it.next());
        }
        ((JRDesignChart)this.getChart()).setDataset(null);
    }

    public void setChart(JRDesignChart chart) {
        JRChart old = this.chart;
        this.chart = chart;
        this.getEventSupport().firePropertyChange(PROPERTY_CHART, (Object)old, (Object)this.chart);
    }
}

