/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignXyDataset
extends JRDesignChartDataset
implements JRXyDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_XY_SERIES = "xySeries";
    private List<JRXySeries> xySeriesList = new ArrayList<JRXySeries>();

    @JsonCreator
    private JRDesignXyDataset() {
        this(null);
    }

    public JRDesignXyDataset(JRChartDataset dataset) {
        super(dataset);
    }

    @Override
    public JRXySeries[] getSeries() {
        JRXySeries[] xySeriesArray = new JRXySeries[this.xySeriesList.size()];
        this.xySeriesList.toArray(xySeriesArray);
        return xySeriesArray;
    }

    @JsonIgnore
    public List<JRXySeries> getSeriesList() {
        return this.xySeriesList;
    }

    @JsonSetter
    private void setSeries(List<JRXySeries> series) {
        if (series != null) {
            for (JRXySeries s : series) {
                this.addXySeries(s);
            }
        }
    }

    public void addXySeries(JRXySeries xySeries) {
        this.xySeriesList.add(xySeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_XY_SERIES, (Object)xySeries, this.xySeriesList.size() - 1);
    }

    public void addXySeries(int index, JRXySeries xySeries) {
        this.xySeriesList.add(index, xySeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_XY_SERIES, (Object)xySeries, index);
    }

    public JRXySeries removeXySeries(JRXySeries xySeries) {
        int idx;
        if (xySeries != null && (idx = this.xySeriesList.indexOf(xySeries)) >= 0) {
            this.xySeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_XY_SERIES, (Object)xySeries, idx);
        }
        return xySeries;
    }

    @Override
    public byte getDatasetType() {
        return 3;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRDesignXyDataset clone = (JRDesignXyDataset)super.clone();
        clone.xySeriesList = JRCloneUtils.cloneList(this.xySeriesList);
        return clone;
    }
}

