/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.ChartVisitorFactory;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRAbstractChartCustomizer;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRChartCustomizer;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.NamedChartCustomizer;
import net.sf.jasperreports.charts.fill.ChartTemplateImage;
import net.sf.jasperreports.charts.fill.ChartsFillObjectFactory;
import net.sf.jasperreports.charts.fill.JRFillCategoryDataset;
import net.sf.jasperreports.charts.fill.JRFillChartAxis;
import net.sf.jasperreports.charts.fill.JRFillChartDataset;
import net.sf.jasperreports.charts.fill.JRFillChartPlot;
import net.sf.jasperreports.charts.fill.JRFillGanttDataset;
import net.sf.jasperreports.charts.fill.JRFillHighLowDataset;
import net.sf.jasperreports.charts.fill.JRFillMultiAxisPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillXyDataset;
import net.sf.jasperreports.charts.fill.JRFillXyzDataset;
import net.sf.jasperreports.charts.type.AxisPositionEnum;
import net.sf.jasperreports.charts.type.ChartTypeEnum;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.util.CategoryChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.charts.util.HighLowChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.charts.util.MultiAxisChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.PieChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.TimePeriodChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.TimeSeriesChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.XYChartHyperlinkProvider;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.StyleResolver;
import net.sf.jasperreports.engine.util.StyleUtil;
import net.sf.jasperreports.export.HtmlReportConfiguration;
import net.sf.jasperreports.renderers.Renderable;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.general.Dataset;

public class JRFillChart
extends JRFillElement
implements JRChart {
    public static final String EXCEPTION_MESSAGE_KEY_CUSTOMIZER_INSTANCE_ERROR = "charts.customizer.instance.error";
    public static final String EXCEPTION_MESSAGE_KEY_MULTIAXIS_PLOT_TYPES_MIX_NOT_ALLOWED = "charts.multiaxis.plot.types.mix.not.allowed";
    public static final String EXCEPTION_MESSAGE_KEY_MULTIAXIS_PLOT_NOT_SUPPORTED = "charts.multiaxis.plot.not.supported";
    protected ChartTypeEnum chartType;
    protected JRFont titleFont;
    protected JRFont subtitleFont;
    protected JRFont legendFont;
    protected final JRLineBox initLineBox;
    protected JRLineBox lineBox;
    protected JRFillChartDataset dataset;
    protected JRChartPlot plot;
    protected Renderable renderer;
    private String anchorName;
    private Integer bookmarkLevel;
    private String hyperlinkReference;
    private Boolean hyperlinkWhen;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected List<JRChartCustomizer> chartCustomizers;
    protected String renderType;
    protected ChartTheme theme;
    protected JFreeChart jfreeChart;
    protected ChartHyperlinkProvider chartHyperlinkProvider;

    protected JRFillChart(JRBaseFiller filler, JRChart chart, ChartsFillObjectFactory factory) {
        super(filler, (JRElement)chart, factory.getParent());
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case AREA: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case BAR: 
            case BAR3D: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case BUBBLE: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyzDataset((JRXyzDataset)chart.getDataset()));
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case CANDLESTICK: {
                this.dataset = (JRFillChartDataset)((Object)factory.getHighLowDataset((JRHighLowDataset)chart.getDataset()));
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case HIGHLOW: {
                this.dataset = (JRFillChartDataset)((Object)factory.getHighLowDataset((JRHighLowDataset)chart.getDataset()));
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case LINE: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case METER: {
                this.dataset = (JRFillChartDataset)((Object)factory.getValueDataset((JRValueDataset)chart.getDataset()));
                this.plot = factory.getMeterPlot((JRMeterPlot)chart.getPlot());
                break;
            }
            case MULTI_AXIS: {
                this.plot = factory.getMultiAxisPlot((JRMultiAxisPlot)chart.getPlot());
                this.dataset = ((JRFillMultiAxisPlot)this.plot).getMainDataset();
                break;
            }
            case PIE: 
            case PIE3D: {
                this.dataset = (JRFillChartDataset)((Object)factory.getPieDataset((JRPieDataset)chart.getDataset()));
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case SCATTER: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case STACKEDBAR: 
            case STACKEDBAR3D: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case THERMOMETER: {
                this.dataset = (JRFillChartDataset)((Object)factory.getValueDataset((JRValueDataset)chart.getDataset()));
                this.plot = factory.getThermometerPlot((JRThermometerPlot)chart.getPlot());
                break;
            }
            case TIMESERIES: {
                this.dataset = (JRFillChartDataset)((Object)factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset()));
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case XYAREA: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case XYBAR: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset()));
                        break;
                    }
                    case 5: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset()));
                        break;
                    }
                    case 3: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                        break;
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case XYLINE: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case STACKEDAREA: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case GANTT: {
                this.dataset = (JRFillChartDataset)((Object)factory.getGanttDataset((JRGanttDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("charts.chart.type.not.supported", new Object[]{this.getChartType()});
            }
        }
        JRFillObjectFactory parentFactory = factory.getParent();
        this.titleFont = parentFactory.getFont((JRStyleContainer)chart, chart.getTitleFont());
        this.subtitleFont = parentFactory.getFont((JRStyleContainer)chart, chart.getSubtitleFont());
        this.legendFont = parentFactory.getFont((JRStyleContainer)this, chart.getLegendFont());
        this.initLineBox = chart.getLineBox().clone((JRBoxContainer)this);
        this.chartCustomizers = new ArrayList<JRChartCustomizer>();
        JRChartCustomizer chartCustomizer = this.createAndInitCustomizer(chart.getCustomizerClass(), null);
        if (chartCustomizer != null) {
            this.chartCustomizers.add(chartCustomizer);
        }
        List properties = JRPropertiesUtil.getProperties((JRPropertiesMap)chart.getPropertiesMap(), (String)"net.sf.jasperreports.customizer.class.");
        for (JRPropertiesUtil.PropertySuffix prop : properties) {
            chartCustomizer = this.createAndInitCustomizer(prop.getValue(), prop.getSuffix());
            if (chartCustomizer == null) continue;
            this.chartCustomizers.add(chartCustomizer);
        }
        this.renderType = chart.getRenderType();
        if (this.renderType == null) {
            this.renderType = filler.getPropertiesUtil().getProperty(this.getParentProperties(), "net.sf.jasperreports.chart.render.type");
        }
    }

    protected StyleResolver getStyleResolver() {
        return this.getDefaultStyleProvider().getStyleResolver();
    }

    protected JRChartCustomizer createAndInitCustomizer(String customizerClassName, String customizerName) {
        JRChartCustomizer customizer = null;
        if (customizerClassName != null && customizerClassName.length() > 0) {
            try {
                Class customizerClass = JRClassLoader.loadClassForName((String)customizerClassName);
                customizer = (JRChartCustomizer)customizerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CUSTOMIZER_INSTANCE_ERROR, (Object[])null, (Throwable)e);
            }
            if (customizer instanceof JRAbstractChartCustomizer) {
                ((JRAbstractChartCustomizer)customizer).init(this);
            }
            if (customizer instanceof NamedChartCustomizer) {
                ((NamedChartCustomizer)customizer).setName(customizerName);
            }
        }
        return customizer;
    }

    public void setBand(JRFillBand band) {
        super.setBand(band);
        this.dataset.setBand(band);
        ((JRFillChartPlot)this.plot).setBand(band);
    }

    protected void evaluateStyle(byte evaluation) throws JRException {
        super.evaluateStyle(evaluation);
        this.lineBox = null;
        if (this.providerStyle != null) {
            this.lineBox = this.initLineBox.clone((JRBoxContainer)this);
            StyleUtil.appendBox((JRLineBox)this.lineBox, (JRLineBox)this.providerStyle.getLineBox());
        }
    }

    public ModeEnum getMode() {
        return this.getStyleResolver().getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    @Override
    public Boolean getShowLegend() {
        return ((JRChart)this.parent).getShowLegend();
    }

    @Override
    public void setShowLegend(Boolean isShowLegend) {
    }

    @Override
    public String getRenderType() {
        return this.renderType;
    }

    @Override
    public void setRenderType(String renderType) {
    }

    @Override
    public String getTheme() {
        return ((JRChart)this.parent).getTheme();
    }

    @Override
    public void setTheme(String theme) {
    }

    public EvaluationTimeEnum getEvaluationTime() {
        return EvaluationTimeEnum.getValueOrDefault((EvaluationTimeEnum)((JRChart)this.parent).getEvaluationTime());
    }

    public String getEvaluationGroup() {
        return ((JRChart)this.parent).getEvaluationGroup();
    }

    public JRLineBox getLineBox() {
        return this.lineBox == null ? this.initLineBox : this.lineBox;
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    @Override
    public EdgeEnum getTitlePosition() {
        return ((JRChart)this.parent).getTitlePosition();
    }

    @Override
    public void setTitlePosition(EdgeEnum titlePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Color getTitleColor() {
        return this.getChartsStyleResolver().getTitleColor(this);
    }

    @Override
    public Color getOwnTitleColor() {
        return ((JRChart)this.parent).getOwnTitleColor();
    }

    @Override
    public void setTitleColor(Color titleColor) {
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    @Override
    public Color getOwnSubtitleColor() {
        return ((JRChart)this.parent).getOwnSubtitleColor();
    }

    @Override
    public Color getSubtitleColor() {
        return this.getChartsStyleResolver().getSubtitleColor(this);
    }

    @Override
    public void setSubtitleColor(Color subtitleColor) {
    }

    @Override
    public Color getOwnLegendColor() {
        return ((JRChart)this.parent).getOwnLegendColor();
    }

    @Override
    public Color getLegendColor() {
        return this.getChartsStyleResolver().getLegendColor(this);
    }

    @Override
    public void setLegendColor(Color legendColor) {
    }

    @Override
    public Color getOwnLegendBackgroundColor() {
        return ((JRChart)this.parent).getOwnLegendBackgroundColor();
    }

    @Override
    public Color getLegendBackgroundColor() {
        return this.getChartsStyleResolver().getLegendBackgroundColor(this);
    }

    @Override
    public void setLegendBackgroundColor(Color legendBackgroundColor) {
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    @Override
    public EdgeEnum getLegendPosition() {
        return ((JRChart)this.parent).getLegendPosition();
    }

    @Override
    public void setLegendPosition(EdgeEnum legendPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRExpression getTitleExpression() {
        return ((JRChart)this.parent).getTitleExpression();
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return ((JRChart)this.parent).getSubtitleExpression();
    }

    public HyperlinkTypeEnum getHyperlinkType() {
        return ((JRChart)this.parent).getHyperlinkType();
    }

    public HyperlinkTargetEnum getHyperlinkTarget() {
        return ((JRChart)this.parent).getHyperlinkTarget();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRChart)this.parent).getAnchorNameExpression();
    }

    public JRExpression getBookmarkLevelExpression() {
        return ((JRChart)this.parent).getBookmarkLevelExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRChart)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkWhenExpression() {
        return ((JRChart)this.parent).getHyperlinkWhenExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRChart)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRChart)this.parent).getHyperlinkPageExpression();
    }

    public Locale getLocale() {
        return this.filler.getLocale();
    }

    public TimeZone getTimeZone() {
        return super.getTimeZone();
    }

    @Override
    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRFillChartDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    protected Renderable getRenderable() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    protected JRTemplateImage getJRTemplateImage() {
        return (JRTemplateImage)this.getElementTemplate();
    }

    protected JRTemplateElement createElementTemplate() {
        ChartTemplateImage templateImage = new ChartTemplateImage(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
        templateImage.setUsingCache(false);
        return templateImage;
    }

    protected void rewind() {
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.bookmarkLevel = JRFillChart.getBookmarkLevel((Object)this.evaluateExpression(this.getBookmarkLevelExpression(), evaluation));
            if (this.getEvaluationTime() == EvaluationTimeEnum.NOW) {
                this.evaluateProperties(evaluation);
                this.evaluateStyle(evaluation);
                this.evaluateRenderer(evaluation);
            }
        }
    }

    protected void evaluateRenderer(byte evaluation) throws JRException {
        JFreeChart chart = this.evaluateChart(evaluation);
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        this.renderer = ChartUtil.getInstance(this.filler.getJasperReportsContext()).getChartRenderableFactory(this.getRenderType()).getRenderable(this.filler.getJasperReportsContext(), chart, this.chartHyperlinkProvider, rectangle);
    }

    protected ChartHyperlinkProvider getHyperlinkProvider() {
        return this.chartHyperlinkProvider;
    }

    protected JFreeChart evaluateChart(byte evaluation) throws JRException {
        this.evaluateDatasetRun(evaluation);
        if (this.theme == null) {
            String themeName = this.getTheme();
            if (themeName == null) {
                themeName = this.filler.getPropertiesUtil().getProperty(this.getParentProperties(), "net.sf.jasperreports.chart.theme");
            }
            this.theme = ChartUtil.getInstance(this.filler.getJasperReportsContext()).getTheme(themeName);
        }
        if (this.getChartType() == ChartTypeEnum.MULTI_AXIS) {
            this.createMultiAxisChart(evaluation);
        } else {
            this.jfreeChart = this.theme.createChart(new FillChartContext(evaluation));
            this.chartHyperlinkProvider = this.createChartHyperlinkProvider();
        }
        for (JRChartCustomizer chartCustomizer : this.chartCustomizers) {
            chartCustomizer.customize(this.jfreeChart, this);
        }
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkWhen = (Boolean)this.evaluateExpression(this.getHyperlinkWhenExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters((JRHyperlink)this, (JRFillExpressionEvaluator)this.expressionEvaluator, (byte)evaluation);
        return this.jfreeChart;
    }

    protected boolean prepare(int availableHeight, boolean isOverflow) {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTime() == EvaluationTimeEnum.NOW) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderable() == null) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() {
        JRTemplatePrintImage printImage = new JRTemplatePrintImage(this.getJRTemplateImage(), this.printElementOriginator);
        printImage.setUUID(this.getUUID());
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        HtmlReportConfiguration.forceEmbedImage((JRPropertiesUtil)this.filler.getPropertiesUtil(), (JRPropertiesHolder)this, (JRPropertiesHolder)printImage);
        EvaluationTimeEnum evaluationTime = this.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.NOW) {
            this.copy((JRPrintImage)printImage);
        } else {
            this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)printImage, evaluationTime, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setRenderer(this.getRenderable());
        printImage.setAnchorName(this.getAnchorName());
        if (this.getHyperlinkWhenExpression() == null || Boolean.TRUE.equals(this.hyperlinkWhen)) {
            printImage.setHyperlinkReference(this.getHyperlinkReference());
            printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
            printImage.setHyperlinkPage(this.getHyperlinkPage());
            printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
            printImage.setHyperlinkParameters(this.hyperlinkParameters);
        } else {
            if (printImage instanceof JRTemplatePrintImage) {
                ((JRTemplatePrintImage)printImage).setHyperlinkOmitted(true);
            }
            printImage.setHyperlinkReference(null);
        }
        this.transferProperties((JRPrintElement)printImage);
    }

    @Override
    public ChartTypeEnum getChartType() {
        return this.chartType;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        new ChartsExpressionCollector(collector).collect(this);
    }

    public void visit(JRVisitor visitor) {
        ChartVisitorFactory.getInstance().getChartVisitor(visitor).visitChart(this);
    }

    protected ChartHyperlinkProvider createChartHyperlinkProvider() {
        ChartHyperlinkProvider chartHyperlinkProvider = null;
        block0 : switch (this.getChartType()) {
            case AREA: 
            case BAR: 
            case BAR3D: 
            case LINE: 
            case STACKEDBAR: 
            case STACKEDBAR3D: 
            case STACKEDAREA: {
                chartHyperlinkProvider = new CategoryChartHyperlinkProvider(((JRFillCategoryDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case BUBBLE: {
                chartHyperlinkProvider = new XYChartHyperlinkProvider(((JRFillXyzDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case SCATTER: 
            case XYAREA: 
            case XYLINE: {
                chartHyperlinkProvider = new XYChartHyperlinkProvider(((JRFillXyDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case CANDLESTICK: 
            case HIGHLOW: {
                chartHyperlinkProvider = new HighLowChartHyperlinkProvider(((JRFillHighLowDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case MULTI_AXIS: {
                break;
            }
            case PIE: 
            case PIE3D: {
                chartHyperlinkProvider = new PieChartHyperlinkProvider(((JRFillPieDataset)this.getDataset()).getSectionHyperlinks());
                break;
            }
            case TIMESERIES: {
                chartHyperlinkProvider = new TimeSeriesChartHyperlinkProvider(((JRFillTimeSeriesDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case XYBAR: {
                switch (this.getDataset().getDatasetType()) {
                    case 6: {
                        chartHyperlinkProvider = new TimeSeriesChartHyperlinkProvider(((JRFillTimeSeriesDataset)this.getDataset()).getItemHyperlinks());
                        break block0;
                    }
                    case 5: {
                        chartHyperlinkProvider = new TimePeriodChartHyperlinkProvider(((JRFillTimePeriodDataset)this.getDataset()).getItemHyperlinks());
                        break block0;
                    }
                    case 3: {
                        chartHyperlinkProvider = new XYChartHyperlinkProvider(((JRFillXyDataset)this.getDataset()).getItemHyperlinks());
                        break block0;
                    }
                }
                break;
            }
            case GANTT: {
                chartHyperlinkProvider = new XYChartHyperlinkProvider(((JRFillGanttDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case METER: 
            case THERMOMETER: {
                break;
            }
            default: {
                throw new JRRuntimeException("charts.chart.type.not.supported", new Object[]{this.getChartType()});
            }
        }
        return chartHyperlinkProvider;
    }

    protected void createMultiAxisChart(byte evaluation) throws JRException {
        Plot mainPlot = null;
        JRFillMultiAxisPlot jrPlot = (JRFillMultiAxisPlot)this.getPlot();
        MultiAxisChartHyperlinkProvider multiHyperlinkProvider = new MultiAxisChartHyperlinkProvider();
        Iterator<JRChartAxis> iter = jrPlot.getAxes().iterator();
        if (iter.hasNext()) {
            JRFillChartAxis axis = (JRFillChartAxis)iter.next();
            JRFillChart fillChart = axis.getFillChart();
            this.jfreeChart = fillChart.evaluateChart(evaluation);
            mainPlot = this.jfreeChart.getPlot();
            ChartHyperlinkProvider axisHyperlinkProvider = fillChart.getHyperlinkProvider();
            if (mainPlot instanceof CategoryPlot) {
                CategoryPlot categoryPlot = (CategoryPlot)mainPlot;
                categoryPlot.setRangeAxisLocation(0, this.getChartAxisLocation(axis));
                if (axisHyperlinkProvider != null) {
                    multiHyperlinkProvider.addHyperlinkProvider((Dataset)categoryPlot.getDataset(), axisHyperlinkProvider);
                }
            } else if (mainPlot instanceof XYPlot) {
                XYPlot xyPlot = (XYPlot)mainPlot;
                xyPlot.setRangeAxisLocation(0, this.getChartAxisLocation(axis));
                if (axisHyperlinkProvider != null) {
                    multiHyperlinkProvider.addHyperlinkProvider((Dataset)xyPlot.getDataset(), axisHyperlinkProvider);
                }
            }
        }
        int axisNumber = 0;
        while (iter.hasNext()) {
            CategoryPlot axisPlot;
            JRFillChartAxis chartAxis = (JRFillChartAxis)iter.next();
            JRFillChart fillChart = chartAxis.getFillChart();
            fillChart.evaluatePrintWhenExpression(evaluation);
            if (!fillChart.isPrintWhenExpressionNull() && !fillChart.isPrintWhenTrue()) continue;
            ++axisNumber;
            JFreeChart axisChart = fillChart.evaluateChart(evaluation);
            ChartHyperlinkProvider axisHyperlinkProvider = fillChart.getHyperlinkProvider();
            if (mainPlot instanceof CategoryPlot) {
                CategoryPlot mainCatPlot = (CategoryPlot)mainPlot;
                if (!(axisChart.getPlot() instanceof CategoryPlot)) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_MULTIAXIS_PLOT_TYPES_MIX_NOT_ALLOWED, (Object[])null);
                }
                axisPlot = (CategoryPlot)axisChart.getPlot();
                mainCatPlot.setRangeAxis(axisNumber, axisPlot.getRangeAxis());
                mainCatPlot.setRangeAxisLocation(axisNumber, this.getChartAxisLocation(chartAxis));
                mainCatPlot.setDataset(axisNumber, axisPlot.getDataset());
                mainCatPlot.mapDatasetToRangeAxis(axisNumber, axisNumber);
                mainCatPlot.setRenderer(axisNumber, axisPlot.getRenderer());
                this.configureAxisSeriesColors(axisPlot.getRenderer(), fillChart.getPlot());
                if (axisHyperlinkProvider == null) continue;
                multiHyperlinkProvider.addHyperlinkProvider((Dataset)axisPlot.getDataset(), axisHyperlinkProvider);
                continue;
            }
            if (mainPlot instanceof XYPlot) {
                XYPlot mainXyPlot = (XYPlot)mainPlot;
                if (!(axisChart.getPlot() instanceof XYPlot)) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_MULTIAXIS_PLOT_TYPES_MIX_NOT_ALLOWED, (Object[])null);
                }
                axisPlot = (XYPlot)axisChart.getPlot();
                mainXyPlot.setRangeAxis(axisNumber, axisPlot.getRangeAxis());
                mainXyPlot.setRangeAxisLocation(axisNumber, this.getChartAxisLocation(chartAxis));
                mainXyPlot.setDataset(axisNumber, axisPlot.getDataset());
                mainXyPlot.mapDatasetToRangeAxis(axisNumber, axisNumber);
                mainXyPlot.setRenderer(axisNumber, axisPlot.getRenderer());
                this.configureAxisSeriesColors(axisPlot.getRenderer(), fillChart.getPlot());
                if (axisHyperlinkProvider == null) continue;
                multiHyperlinkProvider.addHyperlinkProvider((Dataset)axisPlot.getDataset(), axisHyperlinkProvider);
                continue;
            }
            throw new JRException(EXCEPTION_MESSAGE_KEY_MULTIAXIS_PLOT_NOT_SUPPORTED, (Object[])null);
        }
        this.chartHyperlinkProvider = multiHyperlinkProvider;
    }

    private void configureAxisSeriesColors(CategoryItemRenderer renderer, JRChartPlot jrPlot) {
        SortedSet<JRChartPlot.JRSeriesColor> seriesColors = jrPlot.getSeriesColors();
        if (seriesColors != null) {
            for (JRChartPlot.JRSeriesColor seriesColor : seriesColors) {
                renderer.setSeriesPaint(seriesColor.getSeriesOrder(), (Paint)seriesColor.getColor());
            }
        }
    }

    private void configureAxisSeriesColors(XYItemRenderer renderer, JRChartPlot jrPlot) {
        SortedSet<JRChartPlot.JRSeriesColor> seriesColors = jrPlot.getSeriesColors();
        if (seriesColors != null) {
            for (JRChartPlot.JRSeriesColor seriesColor : seriesColors) {
                renderer.setSeriesPaint(seriesColor.getSeriesOrder(), (Paint)seriesColor.getColor());
            }
        }
    }

    protected Range convertRange(JRDataRange dataRange, byte evaluation) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression(), evaluation);
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression(), evaluation);
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval, byte evaluation) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange(), evaluation);
        Color color = interval.getBackgroundColor();
        float[] components = color.getRGBColorComponents(null);
        float alpha = (float)(interval.getAlpha() == null ? 1.0 : interval.getAlpha());
        Color alphaColor = new Color(components[0], components[1], components[2], alpha);
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected AxisLocation getChartAxisLocation(JRFillChartAxis chartAxis) {
        return chartAxis.getPosition() != null && chartAxis.getPosition() == AxisPositionEnum.RIGHT_OR_BOTTOM ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateRenderer(evaluation);
        this.copy((JRPrintImage)element);
        this.filler.updateBookmark(element);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel == null ? ((JRChart)this.parent).getBookmarkLevel() : this.bookmarkLevel.intValue();
    }

    @Override
    public String getCustomizerClass() {
        return ((JRChart)this.parent).getCustomizerClass();
    }

    private void evaluateDatasetRun(byte evaluation) throws JRException {
        this.dataset.evaluateDatasetRun(evaluation);
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRChart)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRChart)this.parent).getLinkType();
    }

    public String getLinkTarget() {
        return ((JRChart)this.parent).getLinkTarget();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRChart)this.parent).getHyperlinkTooltipExpression();
    }

    class FillChartContext
    implements ChartContext {
        private final byte evaluation;

        protected FillChartContext(byte evaluation) {
            this.evaluation = evaluation;
            JRFillChart.this.filler.getJasperReportsContext();
        }

        @Override
        public JasperReportsContext getJasperReportsContext() {
            return JRFillChart.this.filler.getJasperReportsContext();
        }

        @Override
        public String evaluateTextExpression(JRExpression expression) throws JRException {
            return JRStringUtil.getString((Object)JRFillChart.this.evaluateExpression(expression, this.evaluation));
        }

        @Override
        public Object evaluateExpression(JRExpression expression) throws JRException {
            return JRFillChart.this.evaluateExpression(expression, this.evaluation);
        }

        @Override
        public JRChart getChart() {
            return JRFillChart.this;
        }

        @Override
        public Dataset getDataset() {
            return ((JRFillChartDataset)JRFillChart.this.getDataset()).getDataset();
        }

        @Override
        public Object getLabelGenerator() {
            return ((JRFillChartDataset)JRFillChart.this.getDataset()).getLabelGenerator();
        }

        @Override
        public Locale getLocale() {
            return JRFillChart.this.getLocale();
        }

        @Override
        public TimeZone getTimeZone() {
            return JRFillChart.this.getTimeZone();
        }
    }
}

