/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.hibernate;

import jakarta.persistence.Tuple;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.hibernate.JRHibernateAbstractDataSource;
import net.sf.jasperreports.hibernate.JRHibernateQueryExecuter;
import org.hibernate.ScrollableResults;

public class JRHibernateScrollDataSource
extends JRHibernateAbstractDataSource
implements JRRewindableDataSource {
    private ScrollableResults<Tuple> scrollableResults;

    public JRHibernateScrollDataSource(JRHibernateQueryExecuter queryExecuter, boolean useFieldDescription) {
        super(queryExecuter, useFieldDescription);
        this.scrollableResults = queryExecuter.scroll();
    }

    public boolean next() throws JRException {
        if (this.scrollableResults != null && this.scrollableResults.next()) {
            this.setCurrentRowValue((Tuple)this.scrollableResults.get());
            return true;
        }
        return false;
    }

    public void moveFirst() {
        this.queryExecuter.closeScrollableResults();
        this.scrollableResults = this.queryExecuter.scroll();
    }
}

