/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt;

import com.gc.iotools.fmt.ResettableStreamRASAdapter;
import com.gc.iotools.fmt.ResettableStreamWrapper;
import com.gc.iotools.fmt.base.Decoder;
import com.gc.iotools.fmt.base.DetectionLibrary;
import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.base.ResettableInputStream;
import com.gc.iotools.fmt.decoders.CompositeDecoder;
import com.gc.iotools.fmt.detect.droid.DroidDetectorImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DetectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DroidDetectorImpl.class);
    private final Decoder[] decoders;
    private final DetectionLibrary[] detectionLibraries;
    private FormatEnum[] enabledFormats;
    private final ResettableStreamRASAdapter internalStream;
    private int maxRecursion = 0;
    private IdentificationResult result;

    private static FormatId detectFormatStream(ResettableInputStream stream, DetectionLibrary[] detectors, FormatEnum[] enabledFormats) throws IOException {
        FormatId detected = new FormatId(FormatEnum.UNKNOWN, null);
        ArrayList<FormatEnum> toDetect = new ArrayList<FormatEnum>(Arrays.asList(enabledFormats));
        if (detectors != null) {
            for (int i = 0; i < detectors.length && FormatEnum.UNKNOWN.equals(detected.format) && toDetect.size() > 0; ++i) {
                DetectionLibrary detectionLibrary = detectors[i];
                try {
                    if (DetectionStrategy.isDetectorNeeded(detectionLibrary, toDetect)) {
                        detected = detectionLibrary.detect(toDetect.toArray(new FormatEnum[0]), stream);
                        toDetect.removeAll(Arrays.asList(detectionLibrary.getDetectedFormats()));
                    }
                }
                catch (Exception e) {
                    LOG.debug("detector [" + detectionLibrary + "] threw exception", (Throwable)e);
                }
                stream.resetToBeginning();
            }
        }
        return detected;
    }

    private static Map<FormatEnum, Decoder> getDecodersMap(Decoder[] decoders) {
        HashMap<FormatEnum, Decoder> formatsMap = new HashMap<FormatEnum, Decoder>();
        if (decoders != null) {
            for (Decoder decoder : decoders) {
                formatsMap.put(decoder.getFormat(), decoder);
            }
        }
        return formatsMap;
    }

    private static boolean isDetectorNeeded(DetectionLibrary detect, Collection<FormatEnum> toDetect) {
        FormatEnum[] formats = detect.getDetectedFormats();
        boolean result = false;
        for (int i = 0; i < formats.length && !result; result |= toDetect.contains(formats[i]), ++i) {
        }
        return result;
    }

    public DetectionStrategy(DetectionLibrary[] detectors, Decoder[] decoders, FormatEnum[] enabledFormats, ResettableStreamRASAdapter istream) {
        this.internalStream = istream;
        this.detectionLibraries = detectors;
        this.decoders = decoders;
        this.enabledFormats = enabledFormats;
    }

    private void checkInitialized() throws IOException {
        if (this.result == null) {
            this.result = this.identify();
        }
    }

    private Decoder getDecoder(List<FormatId> formats, Map<FormatEnum, Decoder> decMap) {
        Decoder decoder;
        if (formats.size() > 1) {
            ArrayList<Decoder> decoderColl = new ArrayList<Decoder>();
            for (FormatId formatId1 : formats) {
                FormatEnum format = formatId1.format;
                Decoder decoder1 = decMap.get(format);
                decoderColl.add(decoder1);
            }
            decoder = new CompositeDecoder(decoderColl.toArray(new Decoder[0]));
        } else {
            FormatEnum format = formats.get((int)0).format;
            decoder = decMap.get(format);
        }
        return decoder;
    }

    public FormatId[] getFormats() throws IOException {
        this.checkInitialized();
        return this.result.formats;
    }

    public ResettableInputStream getStream() throws IOException {
        this.checkInitialized();
        return this.result.resettableIs;
    }

    private IdentificationResult identify() throws IOException {
        FormatId curFormat;
        ArrayList<FormatId> formats = new ArrayList<FormatId>();
        Map<FormatEnum, Decoder> decMap = DetectionStrategy.getDecodersMap(this.decoders);
        this.internalStream.enable(true);
        ResettableInputStream currentStream = this.internalStream;
        int recursionLevel = 0;
        do {
            curFormat = DetectionStrategy.detectFormatStream(currentStream, this.detectionLibraries, this.enabledFormats);
            if (recursionLevel == 0 || !FormatEnum.UNKNOWN.equals(curFormat)) {
                formats.add(curFormat);
            }
            if (FormatEnum.UNKNOWN.equals(curFormat.format) || !decMap.containsKey(curFormat.format)) continue;
            Decoder decoder = this.getDecoder(formats, decMap);
            currentStream = new ResettableStreamWrapper(this.internalStream, decoder);
        } while (decMap.containsKey(curFormat.format) && ++recursionLevel <= this.maxRecursion);
        this.internalStream.enable(false);
        return new IdentificationResult(currentStream, formats.toArray(new FormatId[formats.size()]));
    }

    public void setEnabledFormats(FormatEnum[] enabledFormats) {
        this.enabledFormats = enabledFormats;
        this.result = null;
    }

    public void setMaxRecursion(int maxRecursion) {
        if (this.maxRecursion != maxRecursion) {
            this.result = null;
        }
        this.maxRecursion = maxRecursion;
    }

    private class IdentificationResult {
        final FormatId[] formats;
        final ResettableInputStream resettableIs;

        IdentificationResult(ResettableInputStream resettableIs, FormatId[] formats) {
            this.resettableIs = resettableIs;
            this.formats = formats;
        }
    }
}

