/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt;

import com.gc.iotools.fmt.base.Decoder;
import com.gc.iotools.fmt.base.ResettableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResettableStreamWrapper
extends ResettableInputStream {
    private final ResettableInputStream baseStream;
    private InputStream decodedStream;
    private final Decoder decoder;

    public ResettableStreamWrapper(ResettableInputStream originalStream, Decoder decoder) {
        this.baseStream = originalStream;
        this.decoder = decoder;
    }

    private void checkInitialized() throws IOException {
        if (this.decodedStream == null) {
            this.baseStream.resetToBeginning();
            this.decodedStream = this.decoder.decode(this.baseStream);
        }
    }

    @Override
    public void close() throws IOException {
        this.decodedStream = null;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        this.checkInitialized();
        return this.decodedStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkInitialized();
        return this.decodedStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkInitialized();
        return this.decodedStream.read(b, off, len);
    }

    @Override
    public void resetToBeginning() throws IOException {
        this.decodedStream = null;
        this.baseStream.resetToBeginning();
    }

    @Override
    public long skip(long size) throws IOException {
        this.checkInitialized();
        return this.decodedStream.skip(size);
    }
}

