/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.wzf;

import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.detect.wzf.DefiniteLengthModule;

public class StringncDetectorModule
implements DefiniteLengthModule {
    private String byteSequence = null;
    private int detectLength = -1;
    private FormatId detectedFormat;

    @Override
    public boolean detect(byte[] readBytes) {
        String readString = new String(readBytes);
        String ucaseStr = readString.toUpperCase();
        boolean result = this.detectLength == this.byteSequence.length() ? this.byteSequence.equals(ucaseStr) : ucaseStr.contains(this.byteSequence);
        return result;
    }

    @Override
    public FormatId getDetectedFormat() {
        if (this.detectedFormat == null) {
            throw new IllegalStateException("getDetectFormat called before init");
        }
        return this.detectedFormat;
    }

    @Override
    public int getDetectLength() {
        if (this.byteSequence == null) {
            throw new IllegalStateException("getDetectLength called before init");
        }
        return this.detectLength;
    }

    @Override
    public void init(FormatId fenum, String param) {
        int sepPos = param.indexOf(58);
        this.byteSequence = param.substring(sepPos + 1).toUpperCase();
        if (sepPos > 0) {
            String detectLString = param.substring(0, sepPos);
            this.detectLength = Integer.parseInt(detectLString);
        }
        if (this.detectLength <= 0) {
            this.detectLength = this.byteSequence.length();
        }
        this.detectedFormat = fenum;
    }

    public String toString() {
        return "StringNCModule [" + this.detectedFormat + "] len[" + this.detectLength + "] strIgnoreCase [" + this.byteSequence + "]";
    }
}

