/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.wzf.custom;

import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.detect.wzf.DefiniteLengthModule;
import com.gc.iotools.fmt.detect.wzf.custom.ASN1Reader;
import java.io.ByteArrayInputStream;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSDDetector
implements DefiniteLengthModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSDDetector.class);

    @Override
    public boolean detect(byte[] readBytes) {
        ByteArrayInputStream buffer = new ByteArrayInputStream(readBytes);
        boolean result = false;
        try {
            ASN1Reader pkcsHdrRead = new ASN1Reader(buffer);
            pkcsHdrRead.check(CMSObjectIdentifiers.timestampedData);
            result = true;
        }
        catch (Exception e) {
            LOGGER.debug("TSD not recognized. Exception: [" + e.getMessage() + "]");
        }
        return result;
    }

    @Override
    public FormatId getDetectedFormat() {
        return new FormatId(FormatEnum.TSD, null);
    }

    @Override
    public int getDetectLength() {
        return 4096;
    }

    @Override
    public void init(FormatId fenum, String param) {
    }
}

