/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.binFileReader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.base.FileFormatHit;
import uk.gov.nationalarchives.droid.base.SimpleElement;

public class IdentificationFile
extends SimpleElement
implements Comparable {
    private static final Logger LOG = LoggerFactory.getLogger(IdentificationFile.class);
    private final List<FileFormatHit> fileHits = new ArrayList<FileFormatHit>();
    private String filePath;
    private String identificationWarning = "";
    private int myIDStatus = 5;

    public IdentificationFile() {
    }

    public IdentificationFile(String filePath) {
        this.setFilePath(filePath);
    }

    public void addFileFormatHit(FileFormatHit theHit) {
        this.fileHits.add(theHit);
    }

    protected void addHit(FileFormatHit hit) {
        this.fileHits.add(hit);
    }

    public int compareTo(Object otherIDFile) {
        if (this.filePath == null || this.filePath.length() == 0) {
            return -1;
        }
        return this.getFilePath().compareToIgnoreCase(((IdentificationFile)otherIDFile).getFilePath());
    }

    public boolean equals(Object otherIDFile) {
        if (otherIDFile instanceof IdentificationFile) {
            return this.filePath.toLowerCase().equals(((IdentificationFile)otherIDFile).filePath.toLowerCase());
        }
        return false;
    }

    public int getClassification() {
        return this.myIDStatus;
    }

    public String getClassificationText() {
        String theClassificationText = "";
        if (this.myIDStatus == 1) {
            theClassificationText = "Positive";
        } else if (this.myIDStatus == 2) {
            theClassificationText = "Tentative";
        } else if (this.myIDStatus == 3) {
            theClassificationText = "Not identified";
        } else if (this.myIDStatus == 4) {
            theClassificationText = "Error";
        } else if (this.myIDStatus == 5) {
            theClassificationText = "Not yet run";
        }
        return theClassificationText;
    }

    public String getFileName() {
        return new File(this.filePath).getName();
    }

    public String getFilePath() {
        return this.filePath;
    }

    protected FileFormatHit getHit(int theIndex) {
        return this.fileHits.get(theIndex);
    }

    public int getNumHits() {
        return this.fileHits.size();
    }

    public String getWarning() {
        return this.identificationWarning;
    }

    public int hashCode() {
        if (this.filePath == null || this.filePath.length() == 0) {
            return super.hashCode();
        }
        return this.filePath.toLowerCase().hashCode();
    }

    public boolean isClassified() {
        return this.myIDStatus != 5;
    }

    protected void removeHit(int index) {
        this.fileHits.remove(index);
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("Name")) {
            this.setFilePath(theValue);
        } else if (theName.equals("IdentQuality")) {
            if (theValue.equals("Positive")) {
                this.myIDStatus = 1;
            } else if (theValue.equals("Tentative")) {
                this.myIDStatus = 2;
            } else if (theValue.equals("Not identified")) {
                this.myIDStatus = 3;
            } else if (theValue.equals("Error")) {
                this.myIDStatus = 4;
            } else if (theValue.equals("Not yet run")) {
                this.myIDStatus = 5;
            } else {
                LOG.warn("Unknown file status listed: <" + theValue + "> is not the same as <" + "Positive" + ">");
            }
        } else if (theName.equals("Warning")) {
            this.setWarning(theValue);
        } else {
            String theCMDMessage = "WARNING: Unknown XML attribute " + theName + " found for " + this.getElementName() + " ";
            LOG.warn(theCMDMessage);
        }
    }

    protected void setErrorIdent() {
        this.myIDStatus = 4;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setIDStatus(int theStatus) {
        this.myIDStatus = theStatus;
    }

    protected void setNoIdent() {
        this.myIDStatus = 3;
    }

    protected void setPositiveIdent() {
        this.myIDStatus = 1;
    }

    protected void setTentativeIdent() {
        this.myIDStatus = 2;
    }

    public void setWarning(String warning) {
        this.identificationWarning = warning;
    }
}

