/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.binFileReader;

import com.gc.iotools.fmt.base.ResettableInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.gov.nationalarchives.droid.binFileReader.AbstractByteReader;
import uk.gov.nationalarchives.droid.binFileReader.IdentificationFile;

public final class RandomAccessByteReader
extends AbstractByteReader {
    private static final int BUFFER_MAX_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private long bufferStartOffset = 0L;
    private long fileMarker = 0L;
    private final long len;
    private long position = 0L;
    private final ResettableInputStream ras;

    public RandomAccessByteReader(IdentificationFile theIDFile, ResettableInputStream stream) throws IOException {
        super(theIDFile);
        this.ras = stream;
        this.len = this.getSize(stream);
        this.ras.resetToBeginning();
        this.position = 0L;
    }

    @Override
    public byte getByte(long fileIndex) {
        byte result;
        if (fileIndex >= this.len) {
            throw new ArrayIndexOutOfBoundsException("Read position[" + fileIndex + "] is above EOF");
        }
        if (this.bufferStartOffset <= fileIndex && fileIndex < this.bufferStartOffset + (long)this.buffer.length) {
            result = this.buffer[(int)(fileIndex - this.bufferStartOffset)];
        } else {
            try {
                long startIndex = Math.max(0L, fileIndex - 2048L);
                if (this.position > startIndex && this.position < startIndex + 4096L) {
                    int copyLen = (int)(this.position - startIndex);
                    System.arraycopy(this.buffer, (int)(startIndex - this.bufferStartOffset), this.buffer, 0, copyLen);
                    int read = this.readLenBytes(copyLen);
                    this.position += (long)read;
                } else {
                    this.seek(startIndex);
                    int read = this.readLenBytes(0);
                    this.position = startIndex + (long)read;
                }
                this.bufferStartOffset = startIndex;
                result = this.buffer[(int)(fileIndex - this.bufferStartOffset)];
            }
            catch (IOException e) {
                throw new IllegalStateException("Read position[" + fileIndex + "] had exception.", e);
            }
        }
        return result;
    }

    @Override
    public long getFileMarker() {
        return this.fileMarker;
    }

    @Override
    public long getNumBytes() {
        return this.len;
    }

    private long getSize(InputStream stream) throws IOException {
        long curPos = 0L;
        int readLen = 0;
        byte[] buf = new byte[8192];
        while (readLen >= 0) {
            readLen = stream.read(buf, 0, buf.length);
            if (curPos < (long)this.buffer.length && readLen >= 0) {
                System.arraycopy(buf, 0, this.buffer, (int)curPos, Math.min(readLen, this.buffer.length - (int)curPos));
            }
            if (readLen <= 0) continue;
            curPos += (long)readLen;
        }
        return curPos;
    }

    public int readLenBytes(int copyLen) throws IOException {
        int n;
        int read = 0;
        int len = this.buffer.length - copyLen;
        while (len - read > 0 && (n = this.ras.read(this.buffer, copyLen + read, len - read)) >= 0) {
            read += n;
        }
        return read;
    }

    private void seek(long fileIndex) throws IOException {
        if (fileIndex > this.position) {
            long skip = this.ras.skip(fileIndex - this.position);
            if (skip != fileIndex - this.position) {
                throw new ArrayIndexOutOfBoundsException();
            }
        } else if (fileIndex < this.position) {
            long l;
            this.ras.resetToBeginning();
            if (fileIndex > 0L && (l = this.ras.skip(fileIndex)) != fileIndex) {
                throw new IOException();
            }
        }
    }

    @Override
    public void setFileMarker(long markerPosition) {
        this.fileMarker = markerPosition;
    }
}

