/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signatureFile;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.base.SimpleElement;

public class Shift
extends SimpleElement {
    private static final Logger LOG = LoggerFactory.getLogger(Shift.class);
    private int myShiftByte = 999;
    private long myShiftValue;

    @Override
    public void completeElementContent() {
        String theElementValue = this.getText();
        try {
            this.myShiftValue = Long.parseLong(theElementValue);
        }
        catch (Exception e) {
            LOG.warn("The following non-numerical shift distance was found in the signature file: " + theElementValue);
            this.myShiftValue = 1L;
        }
    }

    public int getShiftByte() {
        return this.myShiftByte;
    }

    public long getShiftValue() {
        return this.myShiftValue;
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("Byte")) {
            try {
                this.myShiftByte = Integer.parseInt(theValue, 16);
            }
            catch (Exception e) {}
        } else {
            String theCMDMessage = "WARNING: Unknown XML attribute " + theName + " found for " + this.getElementName() + " ";
            LOG.warn(theCMDMessage);
        }
    }
}

