/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class JspCompilationInfo {
    private String classFileLocation;
    private String jspSourceLocation;
    private String jspClassName;
    private String javaSourceLocation;
    private String jspPath;
    private String classOutputDir;
    private String webRoot;
    private Map taglibs = new HashMap();
    private static Map compilationHistory = new HashMap();

    private String absolute(String path) {
        return new File(path).getAbsolutePath();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{").append(this.getClass().getName());
        s.append("\n jsp path:   ").append(this.getJspPath());
        s.append(",\n web root:   ").append(this.getWebRoot());
        s.append(",\n jsp file:   ").append(this.getJspSource());
        s.append(",\n java file:  ").append(this.getJavaSource());
        s.append(",\n class file: ").append(this.getClassFile());
        s.append(",\n class name: ").append(this.getClassName());
        s.append(",\n output dir: ").append(this.getClassOutputDir());
        s.append("\n}");
        return s.toString();
    }

    public String getClassName() {
        return this.jspClassName;
    }

    public void setClassName(String jspClassName) {
        this.jspClassName = jspClassName;
    }

    public String getClassFile() {
        return this.classFileLocation;
    }

    public void setClassFile(String classFileLocation) {
        this.classFileLocation = this.absolute(classFileLocation);
    }

    public String getJspSource() {
        return this.jspSourceLocation;
    }

    public void setJspSource(String jspSourceLocation) {
        this.jspSourceLocation = this.absolute(jspSourceLocation);
    }

    public String getJavaSource() {
        return this.javaSourceLocation;
    }

    public void setJavaSource(String javaSourceLocation) {
        this.javaSourceLocation = this.absolute(javaSourceLocation);
    }

    public String getJspPath() {
        return this.jspPath;
    }

    public void setJspPath(String jspPath) {
        this.jspPath = jspPath;
    }

    public String getClassOutputDir() {
        return this.classOutputDir;
    }

    public void setClassOutputDir(String outputDir) {
        this.classOutputDir = this.absolute(outputDir);
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public Map getTaglibs() {
        return this.taglibs;
    }

    public void setTaglibs(Map taglibs) {
        this.taglibs = new HashMap(taglibs);
    }

    public synchronized void compilationWasSuccessful() {
        compilationHistory.put(this.jspSourceLocation, new LastCompile(this.taglibs));
    }

    public synchronized boolean jspCompilationRequired() {
        File jsp = new File(this.jspSourceLocation);
        File java = new File(this.javaSourceLocation);
        File clazz = new File(this.classFileLocation);
        return this.doesNotExistOrIsTooOld(clazz) || this.doesNotExistOrIsTooOld(java) || jsp.lastModified() > java.lastModified() || this.taglibsHaveChangedSinceLastCompile();
    }

    private boolean taglibsHaveChangedSinceLastCompile() {
        LastCompile lastCompile = (LastCompile)compilationHistory.get(this.getJspSource());
        if (lastCompile == null) {
            return true;
        }
        return !((Object)lastCompile.getTaglibs()).equals(this.getTaglibs());
    }

    private boolean doesNotExistOrIsTooOld(File file) {
        long expirationAge = 300000L;
        long expirationThreshold = System.currentTimeMillis() - expirationAge;
        return !file.exists() || file.lastModified() < expirationThreshold;
    }

    private static final class LastCompile {
        private final Map taglibs;

        public LastCompile(Map taglibs) {
            this.taglibs = taglibs;
        }

        public Map getTaglibs() {
            return this.taglibs;
        }
    }
}

