/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.java;

import java.lang.reflect.Method;
import net.sf.jsptest.compiler.java.JavaCompiler;

public class SunJavaC
implements JavaCompiler {
    private static final String SEPARATOR = System.getProperty("path.separator");

    public boolean compile(String pathToJavaSource, String outputDirectory, String[] classpath) throws Exception {
        String classpathString = this.join(classpath);
        String[] args = this.buildArgs(pathToJavaSource, outputDirectory, classpathString);
        return this.compile(args);
    }

    private boolean compile(String[] args) {
        try {
            Class compilerClass = this.getCompileClass();
            Method compilerMethod = this.resolveCompilerMethod(compilerClass);
            Object compilerInstance = compilerClass.newInstance();
            Object[] compilerArguments = new Object[]{args};
            int returnCode = (Integer)compilerMethod.invoke(compilerInstance, compilerArguments);
            return returnCode == 0;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    private String[] buildArgs(String pathToJavaSource, String outputDirectory, String classpathString) {
        return new String[]{"-classpath", classpathString, "-d", outputDirectory, pathToJavaSource};
    }

    private String join(String[] classpath) {
        StringBuffer s = new StringBuffer(5000);
        for (int i = 0; i < classpath.length; ++i) {
            if (s.length() > 0) {
                s.append(SEPARATOR);
            }
            s.append(classpath[i]);
        }
        return s.toString();
    }

    public boolean isAvailable() {
        try {
            this.resolveCompilerMethod(this.getCompileClass());
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private Method resolveCompilerMethod(Class compilerClass) throws NoSuchMethodException {
        return compilerClass.getMethod("compile", new String[0].getClass());
    }

    private Class getCompileClass() throws ClassNotFoundException {
        return Class.forName("com.sun.tools.javac.Main");
    }
}

