/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.utils;

import java.io.File;
import net.sf.jsptest.utils.IO;

public class CustomClassLoader
extends ClassLoader {
    private File baseDir;

    public CustomClassLoader(String baseDir) {
        this(new File(baseDir));
    }

    public CustomClassLoader(File baseDir) {
        this.baseDir = baseDir;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        File classFile = new File(this.baseDir, name.replace('.', '/') + ".class");
        if (!classFile.exists()) {
            return super.loadClass(name);
        }
        try {
            byte[] data = IO.readToByteArray(classFile);
            return this.defineClass(name, data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Class defineClass(String name, byte[] data) throws ClassFormatError {
        return super.defineClass(name, data, 0, data.length);
    }
}

