/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public class Path
extends ArrayList {
    private static final String SEPARATOR = System.getProperty("path.separator");

    public void addSystemProperty(String name) {
        String property = System.getProperty(name);
        if (property != null) {
            String[] systemClasspath = property.split(SEPARATOR);
            for (int i = 0; i < systemClasspath.length; ++i) {
                String entry = systemClasspath[i];
                File file = new File(entry);
                if (file.exists()) {
                    this.add(file.getAbsolutePath());
                    continue;
                }
                this.add(entry);
            }
        }
    }

    public boolean add(Object pathElement) {
        if (this.contains(pathElement)) {
            return false;
        }
        return super.add(pathElement);
    }

    public boolean add(File file) {
        return this.add(file.getAbsolutePath());
    }

    public String[] toStringArray() {
        return this.toArray(new String[this.size()]);
    }

    public void addContainer(Class klass) {
        String resource = this.resourcePathFor(klass);
        this.addJarFile(klass.getResource(resource));
        try {
            ClassLoader context = klass.getClassLoader();
            if (context != null) {
                Enumeration<URL> en = context.getResources(resource);
                while (en.hasMoreElements()) {
                    this.addJarFile(en.nextElement());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String resourcePathFor(Class klass) {
        String resource = klass.getName().replaceAll("\\.", "/");
        return "/" + resource + ".class";
    }

    private void addJarFile(URL url) {
        if (url != null) {
            this.addJarFile(url.toExternalForm());
        }
    }

    private void addJarFile(String url) {
        String prefix = "jar:file:";
        if (url.startsWith(prefix)) {
            String file = url.substring(prefix.length());
            if (file.indexOf("!") > -1) {
                file = file.substring(0, file.indexOf(33));
            }
            this.add(new File(file));
        }
    }
}

