/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class StreamConsumer
implements Runnable {
    private final String outputPrefix;
    private final InputStream stream;
    private final PrintWriter log;

    public StreamConsumer(String streamName, InputStream stream, PrintWriter log) {
        this.outputPrefix = streamName + ":";
        this.stream = stream;
        this.log = log;
    }

    public void run() {
        String output = null;
        try {
            output = this.consume(this.stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.println(this.outputPrefix);
        this.log.println(output);
    }

    private String consume(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(8096);
        byte[] buffer = new byte[8096];
        int r = -1;
        while ((r = stream.read(buffer, 0, buffer.length)) != -1) {
            result.write(buffer, 0, r);
        }
        stream.close();
        return result.toString();
    }
}

