/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.utils;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XML {
    private static final String APACHE_INDENTATION = "{http://xml.apache.org/xslt}indent-amount";

    public static String toString(Node xml) {
        try {
            TransformerFactory f = TransformerFactory.newInstance();
            Transformer t = f.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty(APACHE_INDENTATION, "2");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            t.transform(new DOMSource(xml), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static String textContentOf(Element element) {
        StringBuffer textContent = new StringBuffer(100);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XML.appendTextContentOf(children.item(i), textContent);
        }
        return textContent.toString();
    }

    private static void appendTextContentOf(Node from, StringBuffer to) {
        if (from.getNodeType() == 1) {
            to.append(XML.textContentOf((Element)from));
        } else if (from.getNodeType() != 8) {
            to.append(from.getNodeValue().trim());
        }
    }
}

