///////////////////////////////////////////////////////////////////////////////
//                                                      
// JTOpen (IBM Toolbox for Java - OSS version)                              
//                                                                             
// Filename: AS400ToolboxJarMaker.java
//                                                                             
// The source code contained herein is licensed under the IBM Public License   
// Version 1.0, which has been approved by the Open Source Initiative.         
// Copyright (C) 1997-2001 International Business Machines Corporation and     
// others. All rights reserved.                                                
//                                                                             
///////////////////////////////////////////////////////////////////////////////

package utilities;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.Arrays;


/**
The AS400ToolboxJarMaker class is used to generate a smaller
JAR or ZIP file from the shipped <i>IBM Toolbox for Java</i>
JAR or ZIP file, based on the user's requirements.
<p>
In addition, AS400ToolboxJarMaker can also be used to:
<ul compact>
<li> <em>extract</em> desired files from a JAR or ZIP file; or
<li> <em>split</em> a JAR or ZIP file into smaller JAR or ZIP files.
</ul>
<p>
An AS400ToolboxJarMaker object can be included in the user's program,
or AS400ToolboxJarMaker can be run as a command line program, as follows:
<blockquote>
<pre>
<strong>java utilities.AS400ToolboxJarMaker</strong> [ options ]
</pre>
</blockquote>
AS400ToolboxJarMaker extends the functionality of JarMaker by
additionally allowing the user to specify one or more
<i>IBM Toolbox for Java</i> components,
languages, and/or CCSIDs, and whether or not to include
Java Beans files that are associated with the specified components.

<p>
<b><a name="asoptions">Options</a></b>

<dl>
<dt><b><code>-source </code></b><var>sourceJarFile</var>
<dd>
Specifies the source JAR or ZIP file from which to derive
the destination JAR or ZIP file.  The source file is expected to contain the IBM Toolbox for Java product, and is typically named <code>jt400.jar</code>.
To process a JAR or ZIP other than the Toolbox, use {@link JarMaker JarMaker}.
If a relative path is specified, the path is assumed to be relative to
the current directory.
If this option is specified as the first positional argument,
the tag (<code>-source</code>) is optional. 
The -source option may be abbreviated to -s.
The default is <code>jt400.jar</code>, in the current directory.

<dt><b><code>-destination </code></b><var>destinationJarFile</var>
<dd>
Specifies the destination JAR or ZIP file, which will contain
the desired subset of the files in the source JAR or ZIP file.
If a pathname is not specified, the file is created in the current directory.
The -destination option may be abbreviated to -d.
The default name is generated by appending <code>"Small"</code> to the
source file name.  For example, if the source file is <code>jt400.jar</code>,
then the default destination file would be <code>jt400Small.jar</code>.


<dt><b><code>-fileRequired </code></b><var>jarEntry1[,jarEntry2[...] ] </var>
<dd>
The files in the source JAR or ZIP file that are to be copied to the destination.
Entries are separated by commas (no spaces).
The specified files, along with all of their dependencies,
will be considered required.
Files are specified in JAR entry name syntax, such as <code>com/ibm/as400/access/DataQueue.class</code>.
The -fileRequired option may be abbreviated to -fr.


<dt><b><code>-fileExcluded </code></b><var>jarEntry1[,jarEntry2[...] ] </var>
<dd>
The files in the source JAR or ZIP file that are to be excluded from the destination,
and from dependency analysis.
Entries are separated by commas (no spaces).
Files are specified in JAR entry name syntax, such as <code>com/ibm/as400/access/DataQueue.class</code>.
The -fileExcluded option may be abbreviated to -fx.


<dt><b><code>-additionalFile </code></b><var>file1[,file2[...] ] </var>
<dd>
Specifies additional files (not included in the source jar) which are
to be copied to the destination.
Entries are separated by commas (no spaces).
Files are specified by either their
absolute path, or their path relative to the current directory.
<br>The specified files will be included, regardless of the settings of
other options.
The -additionalFile option may be abbreviated to -af.


<dt><b><code>-additionalFilesDirectory </code></b><var>baseDirectory</var>
<dd>
Specifies the base directory for additional files.
This should be the parent directory of the
directory where the package path starts.  For example, if file <code>foo.class</code>
in package <code>com.ibm.mypackage</code> is located in directory
<code>C:\dir1\subdir2\com\ibm\mypackage\</code>, then specify base directory <code>C:\dir1\subdir2</code>.
<br>The -additionalFilesDirectory option may be abbreviated to -afd.
The default is the current directory.


<dt><b><code>-package </code></b><var>package1[,package2[...] ] </var>
<dd>
The packages that are required.
Entries are separated by commas (no spaces).
The -package option may be abbreviated to -p.
Package names are specified in standard syntax, such as <code>com.ibm.component</code>.
<br>Note: The specified packages are simply included in the output.
No additional dependency analysis is done on the files in a package,
unless they are explicitly specified as required files.


<dt><b><code>-packageExcluded </code></b><var>package1[,package2[...] ] </var>
<dd>
The packages that are to be excluded.
Entries are separated by commas (no spaces).
The -packageExcluded option may be abbreviated to -px.
Package names are specified in standard syntax, such as <code>com.ibm.component</code>.


<dt><b><code>-extract </code></b><var>[baseDirectory]</var>
<dd>
Extracts the desired entries of the source JAR into the specified base directory,
without generating a new JAR or ZIP file.  This option enables the
user to build up a customized JAR or ZIP file empirically,
based on the requirements of their particular application.
When this option is specified, <code>-additionalFile</code>,
<code>-additionalFilesDirectory</code>, and <code>-destination</code>
are ignored.
The -extract option may be abbreviated to -x.
By default, no extraction is done.
The default base directory is the current directory.


<dt><b><code>-split </code></b><var>[splitSize]</var>
<dd>
Splits the source JAR or ZIP file into smaller JAR or ZIP files.
No ZIP entries are added or removed;
the entries in the source JAR or ZIP file are simply distributed
among the destination JAR or ZIP files.
The split size is in units of kilobytes (1024 bytes),
and specifies the maximum size for the destination files.
The destination files are created in the current directory,
and are named by appending integers to the source file name;
any existing files by the same name are overwritten.
For example, if the source JAR file is <code>myfile.jar</code>,
then the destination JAR files would be
<code>myfile0.jar</code>, <code>myfile1.jar</code>, and so on.
When this option is specified, all other options except
<code>-source</code> and <code>-verbose</code> are ignored.
The -split option may be abbreviated to -sp.
The default split size is 2 megabytes (2048 kilobytes).


<dt><b><code>-component </code></b><var>componentID1[,componentID2[...] ] </var>
<dd>
The <i>IBM Toolbox for Java</i> components that are required.
Entries are separated by commas (no spaces), and are case insensitive.
The -component option may be abbreviated to -c.
<br>
See the list of <a href="doc-files/componentList.html">components</a>
that are supported by <i>IBM Toolbox for Java</i>.


<dt><b><code>-beans </code></b>
<dd>
Causes inclusion of all Java Beans files (classes, gifs) that are
directly associated with the specified components.
This option is valid only if <code>-component</code> is also specified.
The -beans option may be abbreviated to -b.
The default is no Beans.


<dt><b><code>-language </code></b><var>language1[,language2[...]]</var>
<dd>
Specifies the desired languages for the messages produced by the Toolbox classes.
Entries are separated by commas (no spaces).
The languages are identified by their Java locale name, such as fr_CA
(for Canadian French).
<br>Note: The shipped jt400.jar file contains only English messages.
The -language option may be abbreviated to -l.
By default, only English messages are included.


<dt><b><code>-languageDirectory </code></b><var>baseDirectory</var>
<dd>
Specifies the base directory for additional Toolbox language files.
The path below this directory should correspond to the package name
the language files.
For example, if the desired MRI files are located in directories
<code>/usr/myDir/com/ibm/as400/access/</code> and
<code>/usr/myDir/com/ibm/as400/vaccess/</code>,
then the base directory should be set to <code>/usr/myDir</code>.
<br>The -languageDirectory option may be abbreviated to -ld.
By default, language files are searched for relative to the
current directory.


<dt><b><code>-ccsid </code></b><var>ccsid1[,ccsid2[...]]</var>
<dd>
Specifies the CCSIDs whose conversion tables should be included.
Conversion tables for other CCSIDs will not be included.
Entries are separated by commas (no spaces).
The -ccsid option may be abbreviated to -cc.
By default, all CCSIDs are included.
See the list of <a href="doc-files/ccsidList.html">CCSIDs and encodings</a>
that are specifically supported by <i>IBM Toolbox for Java</i>.


<dt><b><code>-ccsidExcluded </code></b><var>ccsid1[,ccsid2[...]]</var>
<dd>
Specifies the CCSIDs whose conversion tables should <em>not</em> be included.
Entries are separated by commas (no spaces).  If a CCSID is specified on
both the <code>-ccsid</code> and <code>-ccsidExcluded</code>, it is included,
and a warning message is sent to <code>System.err</code>.
The -ccsidExcluded option may be abbreviated to -cx or -ccx.
By default, all CCSIDs are included.
See the list of <a href="doc-files/ccsidList.html">CCSIDs and encodings</a>
that are specifically supported by <i>IBM Toolbox for Java</i>.


<dt><b><code>-excludeSomeDependencies </code></b>
<dd>
Indicates that AS400ToolboxJarMaker is allowed to selectively limit
dependency expansion, and exclude certain classes, components and packages
that are unlikely to be needed.
By default, this option is not in effect; that is, all directly- and
indirectly-referenced files in the source JAR file are included.


<dt><b><code>-noProxy </code></b>
<dd>
Specifies that proxy-related class files should <em>not</em> be included.
Proxy files are used internally by the Toolbox's Proxy Service.
If the Proxy Service will not be used, the proxy files are not needed.
The -noProxy option may be abbreviated to -np.
By default, proxy files in the source JAR file are included.


<dt><b><code>-verbose </code></b>
<dd>
Causes progress messages to be displayed.
The -verbose option may be abbreviated to -v.
The default is non-verbose.


<dt><b><code>-help </code></b>
<dd>
Displays the help text.
The -help option may be abbreviated to -h.
The default is non-verbose.

</dl>

<p>
At least one of the following options must be specified:
<ul compact>
<li>-fileRequired
<li>-fileExcluded
<li>-additionalFile
<li>-package
<li>-packageExcluded
<li>-extract
<li>-split
<li>-component
<li>-language
<li>-ccsid
<li>-ccsidExcluded
<li>-noProxy
<li>-excludeSomeDependencies
</ul>

<p>
If the following options are specified multiple times in a single command
string, only the final specification applies:
<ul compact>
<li>-source
<li>-destination
<li>-additionalFilesDirectory
<li>-extract
<li>-split
<li>-languageDirectory
</ul>
Other options have a cumulative effect when specified multiple times
in a single command string.

<p>
<b><a name="exam">Example usage</a></b>

<p>
To create a JAR file that contains only those files needed
by the <code>CommandCall</code> and <code>ProgramCall</code> components,
do the following:
<ol>
<li>Go to the directory where the <code>jt400.jar</code> file is located.
<li>Type:
<pre>
java utilities.AS400ToolboxJarMaker -component CommandCall,ProgramCall
</pre>
<li>Save a copy of the original <code>jt400.jar</code> for future reference.
<li>Rename <code>jt400Small.jar</code> to <code>jt400.jar</code>.
</ol>
<p>
To extract from jt400.jar only those files needed
by class <code>com.ibm.as400.access.JDSQLStatement</code>,
using the current directory as the base directory for output, do the following:
<pre>
java utilities.AS400ToolboxJarMaker -extract -s jt400.jar
     -fr com/ibm/as400/access/JDSQLStatement.class
</pre>
Any additional files could then be manually copied into appropriate locations
in the directory tree, and a customized JAR file could be generated using the
<code>jar</code> tool provided as part of the JDK.



@deprecated Use Java 9 module tools instead.
**/

// Design notes
/*
Assumptions:

This tool will be used only by programmers
and administrators for whom English messages are acceptable.
Hence, no translated MRI is provided with this tool.

This tool will be used on JDK 1.1 or later.
When we move to JDK 1.2, the implementation of this tool can take
advantage of the utilities in the new java.util.jar package.

The manifest will be altered based on the list of functions the user specifies.

We need to generate and put our own Javadoc for this tool.  The build process does
not run Javadoc twice because the 'extra' output files (index, table of contents, ...)
would get overlayed.  It is easier to run javadoc locally then just put the output file.
(As an alternative in this release, we could ask the builders if they could generate
this javadoc at the same time as our access and vaccess stuff.)

We are going to include only run-time gifs.  Compile time gifs needed by visual builders
will not be put in the JAR unless explicitly specified.
*/

// * On-going TBDs:
// * Implementation:   Add new components as they are added to Toolbox.
//
// * Implementation:   Add new language MRI suffixes as they are supported.
//
// * Implementation:  When we move to JDK 1.2, 
//                    we can take advantage of the java.util.jar support.
//

public class AS400ToolboxJarMaker extends ToolboxJarMaker
{
  private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";


  // Constants.

  // Note: The following list must be kept in sync with VALID_COMPONENTS.

  /** Constant for specifying the <b>AS400</b> component. **/
  public static final Integer AS400 = ToolboxJarMaker.AS400;
  /** Constant for specifying the <b>Command Call</b> component. **/
  public static final Integer COMMAND_CALL = ToolboxJarMaker.COMMAND_CALL;
  /** Constant for specifying the <b>Data Area</b> component. **/
  public static final Integer DATA_AREA = ToolboxJarMaker.DATA_AREA;
  /** Constant for specifying the <b>Data Description</b> component. **/
  public static final Integer DATA_DESCRIPTION = ToolboxJarMaker.DATA_DESCRIPTION;
  /** Constant for specifying the <b>Data Queue</b> component. **/
  public static final Integer DATA_QUEUE = ToolboxJarMaker.DATA_QUEUE;
  /** Constant for specifying the <b>Digital Certificate</b> component. **/
  public static final Integer DIGITAL_CERTIFICATE = ToolboxJarMaker.DIGITAL_CERTIFICATE;
  /** Constant for specifying the <b>FTP</b> component. **/
  public static final Integer FTP = ToolboxJarMaker.FTP;
  /** Constant for specifying the <b>Integrated File System</b> component. **/
  public static final Integer INTEGRATED_FILE_SYSTEM = ToolboxJarMaker.INTEGRATED_FILE_SYSTEM;
  /** Constant for specifying the <b>JAAS</b> component. **/
  public static final Integer JAAS = ToolboxJarMaker.JAAS;
  /** Constant for specifying the <b>Java Application Call</b> component. **/
  public static final Integer JAVA_APPLICATION_CALL = ToolboxJarMaker.JAVA_APPLICATION_CALL;
  /** Constant for specifying the <b>JDBC</b> component. **/
  public static final Integer JDBC = ToolboxJarMaker.JDBC;
  /** Constant for specifying the <b>Job</b> component. **/
  public static final Integer JOB = ToolboxJarMaker.JOB;
  /** Constant for specifying the <b>Message Queue</b> component. **/
  public static final Integer MESSAGE = ToolboxJarMaker.MESSAGE;
  /** Constant for specifying the <b>Numeric Data Types</b> component. **/
  public static final Integer NUMERIC_DATA_TYPES = ToolboxJarMaker.NUMERIC_DATA_TYPES;
  /** Constant for specifying the <b>Network Print</b> component. **/
  public static final Integer PRINT = ToolboxJarMaker.PRINT;
  /** Constant for specifying the <b>Program Call</b> component. **/
  public static final Integer PROGRAM_CALL = ToolboxJarMaker.PROGRAM_CALL;
  /** Constant for specifying the <b>Record Level Access</b> component. **/
  public static final Integer RECORD_LEVEL_ACCESS = ToolboxJarMaker.RECORD_LEVEL_ACCESS;
  /** Constant for specifying the <b>Secure AS400</b> component.
   This component performs SSL (Secure Sockets Layer) processing. **/
  public static final Integer SECURE_AS400 = ToolboxJarMaker.SECURE_AS400;
  /** Constant for specifying the <b>Service Program Call</b> component. **/
  public static final Integer SERVICE_PROGRAM_CALL = ToolboxJarMaker.SERVICE_PROGRAM_CALL;
  /** Constant for specifying the <b>System Status</b> component. **/
  public static final Integer SYSTEM_STATUS = ToolboxJarMaker.SYSTEM_STATUS;
  /** Constant for specifying the <b>System Value</b> component. **/
  public static final Integer SYSTEM_VALUE = ToolboxJarMaker.SYSTEM_VALUE;
  /** Constant for specifying the <b>Trace</b> component. **/
  public static final Integer TRACE = ToolboxJarMaker.TRACE;
  /** Constant for specifying the <b>User</b> component. **/
  public static final Integer USER = ToolboxJarMaker.USER;
  /** Constant for specifying the <b>User Space</b> component. **/
  public static final Integer USER_SPACE = ToolboxJarMaker.USER_SPACE;
  /** Constant for specifying the <b>Visual AS400</b> component. **/
  public static final Integer AS400_VISUAL = ToolboxJarMaker.AS400_VISUAL;
  /** Constant for specifying the <b>Visual Command Call</b> component. **/
  public static final Integer COMMAND_CALL_VISUAL = ToolboxJarMaker.COMMAND_CALL_VISUAL;
  /** Constant for specifying the <b>Visual Data Queue</b> component. **/
  public static final Integer DATA_QUEUE_VISUAL = ToolboxJarMaker.DATA_QUEUE_VISUAL;
  /** Constant for specifying the <b>Visual Integrated File System </b> component. **/
  public static final Integer INTEGRATED_FILE_SYSTEM_VISUAL = ToolboxJarMaker.INTEGRATED_FILE_SYSTEM_VISUAL;
  /** Constant for specifying the <b>Visual Java Application Call</b> component. **/
  public static final Integer JAVA_APPLICATION_CALL_VISUAL = ToolboxJarMaker.JAVA_APPLICATION_CALL_VISUAL;
  /** Constant for specifying the <b>Visual JDBC</b> component. **/
  public static final Integer JDBC_VISUAL = ToolboxJarMaker.JDBC_VISUAL;  // and Visual SQL
  /** Constant for specifying the <b>Visual Job</b> component. **/
  public static final Integer JOB_VISUAL = ToolboxJarMaker.JOB_VISUAL;
  /** Constant for specifying the <b>Visual Message Queue</b> component. **/
  public static final Integer MESSAGE_VISUAL = ToolboxJarMaker.MESSAGE_VISUAL;
  /** Constant for specifying the <b>Visual Network Print</b> component. **/
  public static final Integer PRINT_VISUAL = ToolboxJarMaker.PRINT_VISUAL;
  /** Constant for specifying the <b>Visual Program Call</b> component. **/
  public static final Integer PROGRAM_CALL_VISUAL = ToolboxJarMaker.PROGRAM_CALL_VISUAL;
  /** Constant for specifying the <b>Visual Record Level Access</b> component. **/
  public static final Integer RECORD_LEVEL_ACCESS_VISUAL = ToolboxJarMaker.RECORD_LEVEL_ACCESS_VISUAL;
  /** Constant for specifying the <b>Visual User</b> component. **/
  public static final Integer USER_VISUAL = ToolboxJarMaker.USER_VISUAL;
  /** Constant for specifying the <b>Connection Pool</b> component. **/
  public static final Integer CONNECTION_POOL = ToolboxJarMaker.CONNECTION_POOL;  // @A2a
  /** Constant for specifying the <b>NetServer</b> component. **/
  public static final Integer NETSERVER = ToolboxJarMaker.NETSERVER;  // @A3a




  /**
   Constructs an AS400ToolboxJarMaker object.
   **/
  public AS400ToolboxJarMaker()
  {
  }


  /**
   Returns the CCSIDs explicitly to be included.

   @return The CCSIDs explicitly to be included.
   The list will be empty if none has been specified.
   The list will contain only <code>Integer</code> objects.
   **/
  public Vector getCCSIDs() { return super.getCCSIDs(); }


  /**
   Returns CCSIDs to be excluded.

   @return The CCSIDs to be excluded.
   The list will be empty if none has been specified.
   The list will contain only <code>Integer</code> objects.
   **/
  public Vector getCCSIDsExcluded() { return super.getCCSIDsExcluded(); }


  /**
   Returns the required components specified by the user.

   @return The components specified by the user.
   The list will be empty if none has been specified.
   The list will contain only <code>Integer</code> objects.
   See <a href="doc-files/componentList.html">component list</a> for
   a list of integer values and associated components.
   **/
  public Vector getComponents() { return super.getComponents(); }


  /**
   Returns the base directory under which the Toolbox language files
   will be searched for.
   This value is set by <code>setLanguageDirectory()</code>.
   @return The base directory for the language files.
   **/
  public File getLanguageDirectory() { return super.getLanguageDirectory(); }


  /**
   Returns the national languages that explicitly are to be supported.
   The languages are identified by their Java locale name, such as fr_CA
   (for Canadian French).
   Note: Locale <code>en</code> is always implicitly supported.

   @return The national languages that explicitly are to be supported.
   The list will be empty if none has been specified.
   The list will contain only <code>String</code> objects.
   **/
  public Vector getLanguages() { return super.getLanguages(); }



  /**
   Resets the AS400ToolboxJarMaker object to a clean, default state,
   to facilitate object reuse.
   **/
  public void reset()
  {
    super.reset();
  }


  /**
   Specifies the CCSIDs explicitly to be included.
   The conversion tables for only these CCSIDs (and CCSIDs
   specified in any prior invocations) will be included in the output.
   Conversion tables for other CCSIDs will <em>not</em> be included.
   <br>Note: This augments any previously specified CCSIDs.
   This method does not verify the existence of the specified CCSIDs.

   @param ccsidList The CCSIDs explicitly to be included.
   The list should contain only <code>Integer</code> objects.
   See <a href="doc-files/ccsidList.html">CCSIDs and encodings</a>
   for valid values.
   **/
  public void setCCSIDs(Vector ccsidList)
  {
    super.setCCSIDs(ccsidList);
  }

  /**
   Specifies CCSIDs to be excluded.
   The conversion tables for these CCSIDs will not be included in the output.
   <br>Note: This augments any previously specified CCSIDs.
   This method does not verify the existence of the specified CCSIDs.

   @param ccsidList The CCSIDs to be excluded.
   The list should contain only <code>Integer</code> objects.
   **/
  public void setCCSIDsExcluded(Vector ccsidList)
  {
    super.setCCSIDsExcluded(ccsidList);
  }


  /**
   Specifies required <i>IBM Toolbox for Java</i> components.
   Java Beans files associated with the components are <em>not</em>
   automatically included.
   <br>Note: This augments any previously specified components.
   If an unrecognized component is specified, a warning message is
   sent to <code>System.err</code>, and the component is ignored.

   @param components The required components.
   The list should contain only <code>Integer</code> objects.
   See <a href="doc-files/componentList.html">component list</a> for valid values.
   **/
  public void setComponents(Vector components)
  {
    super.setComponents(components);
  }


  /**
   Specifies required <i>IBM Toolbox for Java</i> components.
   <br>Note: This augments any previously specified components.
   If an unrecognized component is specified, a warning message is
   sent to <code>System.err</code>, and the component is ignored.

   @param components The required components.
   The list should contain only <code>Integer</code> objects.
   See <a href="doc-files/componentList.html">component list</a> for valid values.
   @param includeBeans Whether or not Java Beans files associated
   with the components are to be included.
   **/
  public void setComponents(Vector components, boolean includeBeans)
  {
    super.setComponents(components, includeBeans);
  }


  /**
   Specifies the base directory for additional Toolbox language files.
   The path below this directory should correspond to the package name
   the language files.
   <br>
   For example, if the MRI files are located in directories
   <code>/usr/myDir/com/ibm/as400/access</code> and
   <code>/usr/myDir/com/ibm/as400/vaccess</code>,
   then the base directory should be set to <code>/usr/myDir</code>.
   <br>This method does not verify the existence of the specified directory.
   <br>The default language directory is the current directory. 

   @param baseDirectory The base directory for the language files.
   **/
  public void setLanguageDirectory(File baseDirectory)
  {
    super.setLanguageDirectory(baseDirectory);
  }


  /**
   Specifies national languages that explicitly are to be supported.
   Languages are identified by their Java locale name, such as
   <code>fr_CA</code>.
   The language files for the specified languages will be searched for
   in the directory tree specified by <code>setLanguageDirectory</code>,
   or, if no directory has been specified, in the directory tree
   under the current directory.
   <br>Note: This augments any previously specified languages.
   This method does not verify the existence of files for the specified
   languages.
   Locale <code>en</code> is always implicitly supported.
   If an unrecognized language is specified, a warning message is
   sent to <code>System.err</code>, and the language is ignored.

   @param languages The languages to be supported.
   The list should contain only <code>String</code> objects.
   **/
  public void setLanguages(Vector languages)
  {
    super.setLanguages(languages);
  }


  /**
   Specifies whether proxy-only files are to be excluded.
   Proxy files are needed only if the Toolbox's Proxy Service
   will be used.
   By default, all proxy files in the source JAR file are included.

   @param excludeProxies Whether or not proxy-only files
   are to be excluded.
   **/
  public void setProxyFilesExcluded(boolean excludeProxies)
  {
    super.setProxyFilesExcluded(excludeProxies);
  }


  // @A4a
  /**
   Specifies whether AS400ToolboxJarMaker is allowed to selectively limit
   dependency expansion, and exclude certain components and packages
   that are unlikely to be needed.
   By default, this option is not in effect; that is, all directly- and
   indirectly-referenced files in the source JAR file are included.
   Examples of files that may be excluded from the output:
   <ul>
   <li>JDBC classes, if component {@link #JDBC JDBC} has not been specified
   <li>class {@link com.ibm.as400.resource.RJob RJob}, if neither component {@link com.ibm.as400.access.Job Job} nor package <tt>com.ibm.as400.resource</tt> has been specified
   </ul>
   <em>Note: Dependency exclusion is not recommended for pre-V5R2 Toolbox JAR files.</em>

   @param excludeSomeDependencies Whether or not AS400ToolboxJarMaker should
   selectively limit dependency expansion.
   **/
  public void setExcludeSomeDependencies(boolean excludeSomeDependencies)
  {
    super.setExcludeSomeDependencies(excludeSomeDependencies);
  }


  /**
   Performs the actions specified in the invocation arguments.

   @param args The command line arguments.
   **/
  public static void main(String[] args)
  {
    ToolboxJarMaker.main(args);
    System.exit(0);
  }

}
