/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteDistribution {
    public static double KullbackLeibler(double[] dist, double[] reference) {
        double distance = 0.0;
        DiscreteDistribution.checkLengths(dist, reference);
        for (int i = 0; i < dist.length; ++i) {
            if (!(dist[i] > 0.0) || !(reference[i] > 0.0)) continue;
            distance += dist[i] * Math.log(dist[i] / reference[i]);
        }
        return distance;
    }

    public static double symmetricKL(double[] dist, double[] reference) {
        return DiscreteDistribution.KullbackLeibler(dist, reference) + DiscreteDistribution.KullbackLeibler(reference, dist);
    }

    public static double squaredError(double[] dist, double[] reference) {
        double error = 0.0;
        DiscreteDistribution.checkLengths(dist, reference);
        for (int i = 0; i < dist.length; ++i) {
            double difference = dist[i] - reference[i];
            error += difference * difference;
        }
        return error;
    }

    public static double cosine(double[] dist, double[] reference) {
        double v_prod = 0.0;
        double w_prod = 0.0;
        double vw_prod = 0.0;
        DiscreteDistribution.checkLengths(dist, reference);
        for (int i = 0; i < dist.length; ++i) {
            vw_prod += dist[i] * reference[i];
            v_prod += dist[i] * dist[i];
            w_prod += reference[i] * reference[i];
        }
        return vw_prod / (Math.sqrt(v_prod) * Math.sqrt(w_prod));
    }

    public static double entropy(double[] dist) {
        double total = 0.0;
        for (int i = 0; i < dist.length; ++i) {
            if (!(dist[i] > 0.0)) continue;
            total += dist[i] * Math.log(dist[i]);
        }
        return -total;
    }

    protected static void checkLengths(double[] dist, double[] reference) {
        if (dist.length != reference.length) {
            throw new IllegalArgumentException("Arrays must be of the same length");
        }
    }

    public static void normalize(double[] counts, double alpha) {
        int i;
        double total_count = 0.0;
        for (i = 0; i < counts.length; ++i) {
            total_count += counts[i];
        }
        for (i = 0; i < counts.length; ++i) {
            counts[i] = (counts[i] + alpha) / (total_count + (double)counts.length * alpha);
        }
    }

    public static double[] mean(Collection<double[]> distributions) {
        if (distributions.isEmpty()) {
            throw new IllegalArgumentException("Distribution collection must be non-empty");
        }
        Iterator<double[]> iter = distributions.iterator();
        double[] first = iter.next();
        double[][] d_array = new double[distributions.size()][first.length];
        d_array[0] = first;
        for (int i = 1; i < d_array.length; ++i) {
            d_array[i] = iter.next();
        }
        return DiscreteDistribution.mean(d_array);
    }

    public static double[] mean(double[][] distributions) {
        double[] d_mean = new double[distributions[0].length];
        for (int j = 0; j < d_mean.length; ++j) {
            d_mean[j] = 0.0;
        }
        for (int i = 0; i < distributions.length; ++i) {
            for (int j = 0; j < d_mean.length; ++j) {
                int n = j;
                d_mean[n] = d_mean[n] + distributions[i][j] / (double)distributions.length;
            }
        }
        return d_mean;
    }
}

