/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.uci.ics.jung.algorithms.importance.Ranking;
import edu.uci.ics.jung.algorithms.util.IterativeProcess;
import edu.uci.ics.jung.graph.Graph;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractRanker<V, E>
extends IterativeProcess {
    private Graph<V, E> mGraph;
    private List<Ranking<?>> mRankings;
    private boolean mRemoveRankScoresOnFinalize;
    private boolean mRankNodes;
    private boolean mRankEdges;
    private boolean mNormalizeRankings;
    protected LoadingCache<Object, Map<V, Number>> vertexRankScores = CacheBuilder.newBuilder().build(new CacheLoader<Object, Map<V, Number>>(){

        public Map<V, Number> load(Object o) {
            return new HashMap();
        }
    });
    protected LoadingCache<Object, Map<E, Number>> edgeRankScores = CacheBuilder.newBuilder().build(new CacheLoader<Object, Map<E, Number>>(){

        public Map<E, Number> load(Object o) {
            return new HashMap();
        }
    });
    private Map<E, Number> edgeWeights = new HashMap<E, Number>();

    protected void initialize(Graph<V, E> graph, boolean isNodeRanker, boolean isEdgeRanker) {
        if (!isNodeRanker && !isEdgeRanker) {
            throw new IllegalArgumentException("Must rank edges, vertices, or both");
        }
        this.mGraph = graph;
        this.mRemoveRankScoresOnFinalize = true;
        this.mNormalizeRankings = true;
        this.mRankNodes = isNodeRanker;
        this.mRankEdges = isEdgeRanker;
    }

    public Map<Object, Map<V, Number>> getVertexRankScores() {
        return this.vertexRankScores.asMap();
    }

    public Map<Object, Map<E, Number>> getEdgeRankScores() {
        return this.edgeRankScores.asMap();
    }

    public Map<V, Number> getVertexRankScores(Object key) {
        return (Map)this.vertexRankScores.getUnchecked(key);
    }

    public Map<E, Number> getEdgeRankScores(Object key) {
        return (Map)this.edgeRankScores.getUnchecked(key);
    }

    protected Collection<V> getVertices() {
        return this.mGraph.getVertices();
    }

    protected int getVertexCount() {
        return this.mGraph.getVertexCount();
    }

    protected Graph<V, E> getGraph() {
        return this.mGraph;
    }

    @Override
    public void reset() {
    }

    public boolean isRankingNodes() {
        return this.mRankNodes;
    }

    public boolean isRankingEdges() {
        return this.mRankEdges;
    }

    public void setRemoveRankScoresOnFinalize(boolean removeRankScoresOnFinalize) {
        this.mRemoveRankScoresOnFinalize = removeRankScoresOnFinalize;
    }

    protected void onFinalize(Object e) {
    }

    public abstract Object getRankScoreKey();

    @Override
    protected void finalizeIterations() {
        Ranking<Object> ranking;
        ArrayList sortedRankings = new ArrayList();
        int id = 1;
        if (this.mRankNodes) {
            for (V currentVertex : this.getVertices()) {
                ranking = new Ranking<V>(id, this.getVertexRankScore(currentVertex), currentVertex);
                sortedRankings.add(ranking);
                if (this.mRemoveRankScoresOnFinalize) {
                    ((Map)this.vertexRankScores.getUnchecked(this.getRankScoreKey())).remove(currentVertex);
                }
                ++id;
                this.onFinalize(currentVertex);
            }
        }
        if (this.mRankEdges) {
            for (Object currentEdge : this.mGraph.getEdges()) {
                ranking = new Ranking<Object>(id, this.getEdgeRankScore(currentEdge), currentEdge);
                sortedRankings.add(ranking);
                if (this.mRemoveRankScoresOnFinalize) {
                    ((Map)this.edgeRankScores.getUnchecked(this.getRankScoreKey())).remove(currentEdge);
                }
                ++id;
                this.onFinalize(currentEdge);
            }
        }
        this.mRankings = sortedRankings;
        Collections.sort(this.mRankings);
    }

    public List<Ranking<?>> getRankings() {
        return this.mRankings;
    }

    public List<Double> getRankScores(int topKRankings) {
        ArrayList<Double> scores = new ArrayList<Double>();
        int count = 1;
        for (Ranking<?> currentRanking : this.getRankings()) {
            if (count > topKRankings) {
                return scores;
            }
            scores.add(currentRanking.rankScore);
            ++count;
        }
        return scores;
    }

    public double getVertexRankScore(V v) {
        Number rankScore = (Number)((Map)this.vertexRankScores.getUnchecked(this.getRankScoreKey())).get(v);
        if (rankScore != null) {
            return rankScore.doubleValue();
        }
        throw new RuntimeException("setRemoveRankScoresOnFinalize(false) must be called before evaluate().");
    }

    public double getVertexRankScore(V v, Object key) {
        return ((Number)((Map)this.vertexRankScores.getUnchecked(key)).get(v)).doubleValue();
    }

    public double getEdgeRankScore(E e) {
        Number rankScore = (Number)((Map)this.edgeRankScores.getUnchecked(this.getRankScoreKey())).get(e);
        if (rankScore != null) {
            return rankScore.doubleValue();
        }
        throw new RuntimeException("setRemoveRankScoresOnFinalize(false) must be called before evaluate().");
    }

    public double getEdgeRankScore(E e, Object key) {
        return ((Number)((Map)this.edgeRankScores.getUnchecked(key)).get(e)).doubleValue();
    }

    protected void setVertexRankScore(V v, double rankValue, Object key) {
        ((Map)this.vertexRankScores.getUnchecked(key)).put(v, rankValue);
    }

    protected void setEdgeRankScore(E e, double rankValue, Object key) {
        ((Map)this.edgeRankScores.getUnchecked(key)).put(e, rankValue);
    }

    protected void setVertexRankScore(V v, double rankValue) {
        this.setVertexRankScore(v, rankValue, this.getRankScoreKey());
    }

    protected void setEdgeRankScore(E e, double rankValue) {
        this.setEdgeRankScore(e, rankValue, this.getRankScoreKey());
    }

    protected void removeVertexRankScore(V v, Object key) {
        ((Map)this.vertexRankScores.getUnchecked(key)).remove(v);
    }

    protected void removeEdgeRankScore(E e, Object key) {
        ((Map)this.edgeRankScores.getUnchecked(key)).remove(e);
    }

    protected void removeVertexRankScore(V v) {
        ((Map)this.vertexRankScores.getUnchecked(this.getRankScoreKey())).remove(v);
    }

    protected void removeEdgeRankScore(E e) {
        ((Map)this.edgeRankScores.getUnchecked(this.getRankScoreKey())).remove(e);
    }

    protected double getEdgeWeight(E e) {
        return this.edgeWeights.get(e).doubleValue();
    }

    protected void setEdgeWeight(E e, double weight) {
        this.edgeWeights.put(e, weight);
    }

    public void setEdgeWeights(Map<E, Number> edgeWeights) {
        this.edgeWeights = edgeWeights;
    }

    public Map<E, Number> getEdgeWeights() {
        return this.edgeWeights;
    }

    protected void assignDefaultEdgeTransitionWeights() {
        for (V currentVertex : this.getVertices()) {
            Collection outgoingEdges = this.mGraph.getOutEdges(currentVertex);
            double numOutEdges = outgoingEdges.size();
            for (Object currentEdge : outgoingEdges) {
                this.setEdgeWeight(currentEdge, 1.0 / numOutEdges);
            }
        }
    }

    protected void normalizeEdgeTransitionWeights() {
        for (V currentVertex : this.getVertices()) {
            Collection outgoingEdges = this.mGraph.getOutEdges(currentVertex);
            double totalEdgeWeight = 0.0;
            for (Object currentEdge : outgoingEdges) {
                totalEdgeWeight += this.getEdgeWeight(currentEdge);
            }
            for (Object currentEdge : outgoingEdges) {
                this.setEdgeWeight(currentEdge, this.getEdgeWeight(currentEdge) / totalEdgeWeight);
            }
        }
    }

    protected void normalizeRankings() {
        if (!this.mNormalizeRankings) {
            return;
        }
        double totalWeight = 0.0;
        for (V currentVertex : this.getVertices()) {
            totalWeight += this.getVertexRankScore(currentVertex);
        }
        for (V currentVertex : this.getVertices()) {
            this.setVertexRankScore(currentVertex, this.getVertexRankScore(currentVertex) / totalWeight);
        }
    }

    public void printRankings(boolean verbose, boolean printScore) {
        double total = 0.0;
        DecimalFormat formatter = new DecimalFormat("#0.#######");
        int rank = 1;
        for (Ranking<?> currentRanking : this.getRankings()) {
            double rankScore = currentRanking.rankScore;
            if (verbose) {
                System.out.print("Rank " + rank + ": ");
                if (printScore) {
                    System.out.print(formatter.format((Object)rankScore));
                }
                System.out.print("\tVertex Id: " + currentRanking.originalPos);
                System.out.print(" (" + currentRanking.getRanked() + ")");
                System.out.println();
            } else {
                System.out.print(rank + "\t");
                if (printScore) {
                    System.out.print(formatter.format((Object)rankScore));
                }
                System.out.println("\t" + currentRanking.originalPos);
            }
            total += rankScore;
            ++rank;
        }
        if (verbose) {
            System.out.println("Total: " + formatter.format((Object)total));
        }
    }

    public void setNormalizeRankings(boolean normalizeRankings) {
        this.mNormalizeRankings = normalizeRankings;
    }
}

