/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.AbstractGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractTypedGraph<V, E>
extends AbstractGraph<V, E> {
    protected final EdgeType edge_type;

    public AbstractTypedGraph(EdgeType edge_type) {
        this.edge_type = edge_type;
    }

    public EdgeType getDefaultEdgeType() {
        return this.edge_type;
    }

    public EdgeType getEdgeType(E e) {
        return this.hasEqualEdgeType(this.edge_type) ? this.edge_type : null;
    }

    public Collection<E> getEdges(EdgeType edge_type) {
        return this.hasEqualEdgeType(edge_type) ? this.getEdges() : Collections.emptySet();
    }

    public int getEdgeCount(EdgeType edge_type) {
        return this.hasEqualEdgeType(edge_type) ? this.getEdgeCount() : 0;
    }

    protected boolean hasEqualEdgeType(EdgeType edge_type) {
        return this.edge_type.equals((Object)edge_type);
    }

    protected void validateEdgeType(EdgeType edge_type) {
        if (!this.hasEqualEdgeType(edge_type)) {
            throw new IllegalArgumentException("Edge type '" + edge_type + "' does not match the default edge type for this graph: '" + this.edge_type + "'");
        }
    }
}

