/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mavenjython;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonMojo
extends AbstractMojo {
    private static final String SETUPTOOLS_EGG = "setuptools-0.6c11-py2.5.egg";
    private File outputDirectory;
    private List<String> libraries;
    private File temporaryBuildDirectory;
    private List<DefaultArtifact> pluginArtifacts;
    private File libdir;
    private File installlibdir;
    private DefaultArtifact jythonArtifact;
    private URL setuptoolsResource;
    private File setuptoolsJar;
    private File sitepackagesdir;
    private File packageDownloadCacheDir;
    private static final boolean OVERRIDE = false;

    private void setupVariables() throws MojoExecutionException {
        if (this.temporaryBuildDirectory == null) {
            this.temporaryBuildDirectory = new File("target/jython-plugins-tmp");
        }
        this.temporaryBuildDirectory.mkdirs();
        this.packageDownloadCacheDir = new File(this.temporaryBuildDirectory, "build");
        this.packageDownloadCacheDir.mkdir();
        this.libdir = new File(this.temporaryBuildDirectory, "Lib");
        this.installlibdir = new File(this.outputDirectory, "Lib");
        this.jythonArtifact = this.findJythonArtifact();
        if (!this.jythonArtifact.getFile().getName().endsWith(".jar")) {
            throw new MojoExecutionException("I expected " + this.jythonArtifact + " to provide a jar, but got " + this.jythonArtifact.getFile());
        }
        this.setuptoolsResource = ((Object)((Object)this)).getClass().getResource(SETUPTOOLS_EGG);
        if (this.setuptoolsResource == null) {
            throw new MojoExecutionException("resource setuptools egg not found");
        }
        this.setuptoolsJar = new File(this.packageDownloadCacheDir, SETUPTOOLS_EGG);
        this.sitepackagesdir = new File(this.libdir, "site-packages");
    }

    public void execute() throws MojoExecutionException {
        this.setupVariables();
        this.extractJarToDirectory(this.jythonArtifact.getFile(), this.temporaryBuildDirectory);
        this.getLog().info((CharSequence)"installing easy_install ...");
        try {
            if (!this.setuptoolsJar.exists()) {
                FileUtils.copyInputStreamToFile((InputStream)this.setuptoolsResource.openStream(), (File)this.setuptoolsJar);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("copying setuptools failed", (Exception)e);
        }
        this.extractJarToDirectory(this.setuptoolsJar, new File(this.sitepackagesdir, SETUPTOOLS_EGG));
        try {
            IOUtils.write((String)"./setuptools-0.6c11-py2.5.egg\n", (OutputStream)new FileOutputStream(new File(this.sitepackagesdir, "setuptools.pth")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("writing path entry for setuptools failed", (Exception)e);
        }
        this.getLog().info((CharSequence)"installing easy_install done");
        if (this.libraries == null) {
            this.getLog().info((CharSequence)"no python libraries requested");
        } else {
            this.getLog().info((CharSequence)"installing requested python libraries");
            this.runJythonScriptOnInstall(this.temporaryBuildDirectory, this.getEasyInstallArgs("Lib/site-packages/setuptools-0.6c11-py2.5.egg/easy_install.py"));
            this.getLog().info((CharSequence)"installing requested python libraries done");
        }
        this.getLog().info((CharSequence)"copying requested libraries");
        File[] fileArray = this.sitepackagesdir.listFiles((FileFilter)new AndFileFilter(DirectoryFileFilter.INSTANCE, (IOFileFilter)new SuffixFileFilter(".egg")));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File i = fileArray[n2];
            this.getLog().info((CharSequence)("copying " + i + " into " + new File(this.outputDirectory, "Lib")));
            try {
                FileUtils.deleteDirectory((File)new File(this.installlibdir, i.getName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                FileUtils.copyDirectory((File)i, (File)this.installlibdir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("copying " + i + " to " + new File(this.outputDirectory, "Lib") + " failed", (Exception)e);
            }
            ++n2;
        }
        new File(this.installlibdir, "site.py").delete();
        new File(this.installlibdir, "site$py.class").delete();
        this.getLog().info((CharSequence)"copying requested libraries done");
    }

    private List<String> getEasyInstallArgs(String easy_install_script) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        args.add("-cp");
        args.add("." + this.getClassPathSeparator() + "Lib");
        args.add("-Dpython.home=.");
        File jythonFakeExecutable = new File(this.temporaryBuildDirectory, "jython");
        try {
            jythonFakeExecutable.createNewFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("couldn't create file", (Exception)e);
        }
        args.add("-Dpython.executable=" + jythonFakeExecutable.getName());
        args.add("org.python.util.jython");
        args.add(easy_install_script);
        args.add("--build-directory");
        args.add(this.packageDownloadCacheDir.getAbsolutePath());
        args.addAll(this.libraries);
        return args;
    }

    private String getClassPathSeparator() {
        if (File.separatorChar == '\\') {
            return ";";
        }
        return ":";
    }

    public void runJythonScriptOnInstall(File outputDirectory, List<String> args) throws MojoExecutionException {
        Process p;
        this.getLog().info((CharSequence)("running " + args + " in " + outputDirectory));
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(outputDirectory);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Executing jython failed. tried to run: " + pb.command(), (Exception)e);
        }
        this.copyIO(p.getInputStream(), System.out);
        this.copyIO(p.getErrorStream(), System.err);
        this.copyIO(System.in, p.getOutputStream());
        try {
            if (p.waitFor() != 0) {
                throw new MojoExecutionException("Jython failed with return code: " + p.exitValue());
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Python tests were interrupted", (Exception)e);
        }
    }

    public Collection<File> extractJarToDirectory(File jar, File outputDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)("extracting " + jar));
        JarFile ja = this.openJarFile(jar);
        Enumeration<JarEntry> en = ja.entries();
        Collection<File> files = this.extractAllFiles(outputDirectory, ja, en);
        this.closeFile(ja);
        return files;
    }

    private JarFile openJarFile(File jar) throws MojoExecutionException {
        try {
            return new JarFile(jar);
        }
        catch (IOException e) {
            throw new MojoExecutionException("opening jython artifact jar failed", (Exception)e);
        }
    }

    private void closeFile(ZipFile ja) throws MojoExecutionException {
        try {
            ja.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("closing jython artifact jar failed", (Exception)e);
        }
    }

    private Collection<File> extractAllFiles(File outputDirectory, ZipFile ja, Enumeration<JarEntry> en) throws MojoExecutionException {
        ArrayList<File> files = new ArrayList<File>();
        while (en.hasMoreElements()) {
            JarEntry el = en.nextElement();
            if (el.isDirectory()) continue;
            File destFile = new File(outputDirectory, el.getName());
            if (!destFile.exists()) {
                destFile.getParentFile().mkdirs();
                try {
                    FileOutputStream fo = new FileOutputStream(destFile);
                    IOUtils.copy((InputStream)ja.getInputStream(el), (OutputStream)fo);
                    fo.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("extracting " + el.getName() + " from jython artifact jar failed", (Exception)e);
                }
            }
            files.add(destFile);
        }
        return files;
    }

    private DefaultArtifact findJythonArtifact() throws MojoExecutionException {
        for (DefaultArtifact i : this.pluginArtifacts) {
            if (!i.getArtifactId().equals("jython-standalone") || !i.getGroupId().equals("org.python")) continue;
            return i;
        }
        throw new MojoExecutionException("org.python.jython-standalone dependency not found. \nAdd a dependency to jython-standalone to your project: \n\t<dependency>\n\t\t<groupId>org.python</groupId>\n\t\t<artifactId>jython-standalone</artifactId>\n\t\t<version>2.5.2</version>\n\t</dependency>\n");
    }

    private void copyIO(final InputStream input, final OutputStream output) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                catch (IOException e) {
                    JythonMojo.this.getLog().error((Throwable)e);
                }
            }
        }).start();
    }
}

