/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microlog.core;

import net.sf.microlog.core.DefaultLoggerRepository;
import net.sf.microlog.core.Logger;
import net.sf.microlog.core.LoggerRepository;

public class LoggerFactory {
    private static final LoggerRepository loggerRepository = DefaultLoggerRepository.getInstance();

    public static Logger getLogger() {
        return loggerRepository.getRootLogger();
    }

    public static Logger getLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The Logger name must not be null.");
        }
        return loggerRepository.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The clazz must not be null.");
        }
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static void shutdown() {
        System.out.println("Shutting down Microlog");
        loggerRepository.shutdown();
        System.out.println("Microlog shutdown complete. Bye, bye!");
    }

    static LoggerRepository getLoggerRepository() {
        return loggerRepository;
    }
}

