/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microproperties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = -5762897418196039268L;
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String COMMENT_SIGN = "#";
    private static final char EQUAL_CHAR = '=';
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final byte[] buffer = new byte[256];
    protected Properties defaults;
    private final StringBuffer stringBuffer = new StringBuffer(512);

    public Properties() {
    }

    public Properties(Properties defaults) {
        this.defaults = defaults;
    }

    public String getProperty(String key) {
        Object propertyObject = this.get(key);
        String property = null;
        if (propertyObject instanceof String) {
            property = (String)propertyObject;
        } else if (propertyObject != null) {
            property = propertyObject.toString();
        }
        if (property == null && this.defaults != null) {
            this.defaults.getProperty(key);
        }
        return property;
    }

    public String getProperty(String key, String defaultValue) {
        String property = this.getProperty(key);
        if (property == null) {
            property = defaultValue;
        }
        return property;
    }

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public void list(PrintStream printStream) {
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            printStream.print(key);
            printStream.print('=');
            String value = this.getProperty(key);
            printStream.println(value);
        }
    }

    public void load(InputStream inputStream) {
        String configString = this.readPropertyfile(inputStream);
        if (configString != null && configString.length() > 3) {
            this.parseConfigString(this, configString);
        }
    }

    public void save(OutputStream outputStream, String header) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPropertyfile(InputStream inputStream) {
        String configString = null;
        try {
            int readBytes = inputStream.read(this.buffer);
            while (readBytes > 0) {
                String string = new String(this.buffer, 0, readBytes, "UTF-8");
                this.stringBuffer.append(string);
                readBytes = inputStream.read(this.buffer);
            }
            if (this.stringBuffer.length() > 0) {
                configString = this.stringBuffer.toString();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to read property file " + e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close the property file " + e);
            }
        }
        return configString;
    }

    private void parseConfigString(Hashtable properties, String configString) {
        int currentIndex = 0;
        int length = configString.length();
        int linefeedIndex = 0;
        while (currentIndex < length) {
            String currentLine;
            linefeedIndex = configString.indexOf(10, currentIndex);
            int endIndex = configString.length();
            if (linefeedIndex != -1) {
                endIndex = linefeedIndex;
                if (configString.charAt(linefeedIndex - 1) == '\r') {
                    --endIndex;
                }
            }
            if ((currentLine = configString.substring(currentIndex, endIndex)).startsWith(COMMENT_SIGN)) {
                endIndex = currentIndex = linefeedIndex + 1;
            } else {
                int equalIndex = currentLine.indexOf(61);
                if (equalIndex > 0) {
                    String key = currentLine.substring(0, equalIndex);
                    String value = currentLine.substring(equalIndex + 1);
                    properties.put(key, value);
                }
            }
            if (linefeedIndex != -1) {
                currentIndex = linefeedIndex + 1;
                continue;
            }
            currentIndex = configString.length();
        }
    }
}

