/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberClassAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class MemberFinder
extends SimplifiedVisitor
implements MemberVisitor {
    private static final MemberFoundException MEMBER_FOUND = new MemberFoundException();
    private Clazz clazz;
    private Member member;

    public Field findField(Clazz referencingClass, Clazz clazz, String name, String descriptor) {
        return (Field)this.findMember(referencingClass, clazz, name, descriptor, true);
    }

    public Method findMethod(Clazz referencingClass, Clazz clazz, String name, String descriptor) {
        return (Method)this.findMember(referencingClass, clazz, name, descriptor, false);
    }

    public Member findMember(Clazz referencingClass, Clazz clazz, String name, String descriptor, boolean isField) {
        try {
            this.clazz = null;
            this.member = null;
            clazz.hierarchyAccept(true, true, true, false, isField ? new NamedFieldVisitor(name, descriptor, new MemberClassAccessFilter(referencingClass, this)) : new NamedMethodVisitor(name, descriptor, new MemberClassAccessFilter(referencingClass, this)));
        }
        catch (MemberFoundException ex) {
            // empty catch block
        }
        return this.member;
    }

    public Clazz correspondingClass() {
        return this.clazz;
    }

    public boolean isOverriden(Clazz clazz, Method method) {
        String name = method.getName(clazz);
        String descriptor = method.getDescriptor(clazz);
        try {
            this.clazz = null;
            this.member = null;
            clazz.hierarchyAccept(false, false, false, true, new NamedMethodVisitor(name, descriptor, new MemberAccessFilter(0, 2, this)));
        }
        catch (MemberFoundException ex) {
            return true;
        }
        return false;
    }

    public boolean isShadowed(Clazz clazz, Field field) {
        String name = field.getName(clazz);
        String descriptor = field.getDescriptor(clazz);
        try {
            this.clazz = null;
            this.member = null;
            clazz.hierarchyAccept(false, false, false, true, new NamedFieldVisitor(name, descriptor, new MemberAccessFilter(0, 2, this)));
        }
        catch (MemberFoundException ex) {
            return true;
        }
        return false;
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        this.clazz = clazz;
        this.member = member;
        throw MEMBER_FOUND;
    }

    private static class MemberFoundException
    extends RuntimeException {
        private MemberFoundException() {
        }
    }
}

