/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.InstructionConstants;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public abstract class Instruction {
    private static final boolean[] MAY_THROW_EXCEPTIONS = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, false, true, false, false, false, false};
    private static final boolean[] IS_CATEGORY2 = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, false, false, false, true, true, true, false, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false, false, true, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final int[] STACK_POP_COUNTS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 3, 4, 3, 4, 3, 3, 3, 3, 1, 2, 1, 2, 3, 2, 3, 4, 2, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 1, 2, 1, 2, 2, 3, 2, 3, 2, 3, 2, 4, 2, 4, 2, 4, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 4, 2, 2, 4, 4, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 1, 2, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0};
    private static final int[] STACK_PUSH_COUNTS = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 4, 5, 6, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1};
    public byte opcode;

    public byte canonicalOpcode() {
        return this.opcode;
    }

    public abstract Instruction shrink();

    public final void write(CodeAttribute codeAttribute, int offset) {
        this.write(codeAttribute.code, offset);
    }

    public void write(byte[] code, int offset) {
        if (this.isWide()) {
            code[offset++] = -60;
        }
        code[offset++] = this.opcode;
        this.writeInfo(code, offset);
    }

    protected boolean isWide() {
        return false;
    }

    protected abstract void readInfo(byte[] var1, int var2);

    protected abstract void writeInfo(byte[] var1, int var2);

    public abstract int length(int var1);

    public abstract void accept(Clazz var1, Method var2, CodeAttribute var3, int var4, InstructionVisitor var5);

    public String toString(int offset) {
        return "[" + offset + "] " + this.toString();
    }

    public String getName() {
        return InstructionConstants.NAMES[this.opcode & 0xFF];
    }

    public boolean mayThrowExceptions() {
        return MAY_THROW_EXCEPTIONS[this.opcode & 0xFF];
    }

    public boolean isCategory2() {
        return IS_CATEGORY2[this.opcode & 0xFF];
    }

    public int stackPopCount(Clazz clazz) {
        return STACK_POP_COUNTS[this.opcode & 0xFF];
    }

    public int stackPushCount(Clazz clazz) {
        return STACK_PUSH_COUNTS[this.opcode & 0xFF];
    }

    protected static int readByte(byte[] code, int offset) {
        return code[offset] & 0xFF;
    }

    protected static int readShort(byte[] code, int offset) {
        return (code[offset++] & 0xFF) << 8 | code[offset] & 0xFF;
    }

    protected static int readInt(byte[] code, int offset) {
        return code[offset++] << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset] & 0xFF;
    }

    protected static int readValue(byte[] code, int offset, int valueSize) {
        switch (valueSize) {
            case 0: {
                return 0;
            }
            case 1: {
                return Instruction.readByte(code, offset);
            }
            case 2: {
                return Instruction.readShort(code, offset);
            }
            case 4: {
                return Instruction.readInt(code, offset);
            }
        }
        throw new IllegalArgumentException("Unsupported value size [" + valueSize + "]");
    }

    protected static int readSignedByte(byte[] code, int offset) {
        return code[offset];
    }

    protected static int readSignedShort(byte[] code, int offset) {
        return code[offset++] << 8 | code[offset] & 0xFF;
    }

    protected static int readSignedValue(byte[] code, int offset, int valueSize) {
        switch (valueSize) {
            case 0: {
                return 0;
            }
            case 1: {
                return Instruction.readSignedByte(code, offset);
            }
            case 2: {
                return Instruction.readSignedShort(code, offset);
            }
            case 4: {
                return Instruction.readInt(code, offset);
            }
        }
        throw new IllegalArgumentException("Unsupported value size [" + valueSize + "]");
    }

    protected static void writeByte(byte[] code, int offset, int value) {
        if (value > 255) {
            throw new IllegalArgumentException("Unsigned byte value larger than 0xff [" + value + "]");
        }
        code[offset] = (byte)value;
    }

    protected static void writeShort(byte[] code, int offset, int value) {
        if (value > 65535) {
            throw new IllegalArgumentException("Unsigned short value larger than 0xffff [" + value + "]");
        }
        code[offset++] = (byte)(value >> 8);
        code[offset] = (byte)value;
    }

    protected static void writeInt(byte[] code, int offset, int value) {
        code[offset++] = (byte)(value >> 24);
        code[offset++] = (byte)(value >> 16);
        code[offset++] = (byte)(value >> 8);
        code[offset] = (byte)value;
    }

    protected static void writeValue(byte[] code, int offset, int value, int valueSize) {
        switch (valueSize) {
            case 0: {
                break;
            }
            case 1: {
                Instruction.writeByte(code, offset, value);
                break;
            }
            case 2: {
                Instruction.writeShort(code, offset, value);
                break;
            }
            case 4: {
                Instruction.writeInt(code, offset, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value size [" + valueSize + "]");
            }
        }
    }

    protected static void writeSignedByte(byte[] code, int offset, int value) {
        if ((byte)value != value) {
            throw new IllegalArgumentException("Signed byte value out of range [" + value + "]");
        }
        code[offset] = (byte)value;
    }

    protected static void writeSignedShort(byte[] code, int offset, int value) {
        if ((short)value != value) {
            throw new IllegalArgumentException("Signed short value out of range [" + value + "]");
        }
        code[offset++] = (byte)(value >> 8);
        code[offset] = (byte)value;
    }

    protected static void writeSignedValue(byte[] code, int offset, int value, int valueSize) {
        switch (valueSize) {
            case 0: {
                break;
            }
            case 1: {
                Instruction.writeSignedByte(code, offset, value);
                break;
            }
            case 2: {
                Instruction.writeSignedShort(code, offset, value);
                break;
            }
            case 4: {
                Instruction.writeInt(code, offset, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value size [" + valueSize + "]");
            }
        }
    }
}

