/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;

public class DuplicateInitializerFixer
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final char[] TYPES = new char[]{'B', 'C', 'S', 'I', 'Z'};
    private final MemberVisitor extraFixedInitializerVisitor;

    public DuplicateInitializerFixer() {
        this(null);
    }

    public DuplicateInitializerFixer(MemberVisitor extraFixedInitializerVisitor) {
        this.extraFixedInitializerVisitor = extraFixedInitializerVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String descriptor;
        Method similarMethod;
        String name = programMethod.getName(programClass);
        if (name.equals("<init>") && !programMethod.equals(similarMethod = programClass.findMethod(name, descriptor = programMethod.getDescriptor(programClass)))) {
            if (KeepMarker.isKept(programMethod)) {
                programMethod = (ProgramMethod)similarMethod;
            }
            int index = descriptor.indexOf(41);
            int typeCounter = 0;
            while (true) {
                StringBuffer newDescriptorBuffer = new StringBuffer(descriptor.substring(0, index));
                for (int arrayDimension = 0; arrayDimension < typeCounter / TYPES.length; ++arrayDimension) {
                    newDescriptorBuffer.append('[');
                }
                newDescriptorBuffer.append(TYPES[typeCounter % TYPES.length]);
                newDescriptorBuffer.append(descriptor.substring(index));
                String newDescriptor = newDescriptorBuffer.toString();
                if (programClass.findMethod(name, newDescriptor) == null) {
                    programMethod.u2descriptorIndex = new ConstantPoolEditor(programClass).addUtf8Constant(newDescriptor);
                    programMethod.attributesAccept(programClass, this);
                    if (this.extraFixedInitializerVisitor != null) {
                        this.extraFixedInitializerVisitor.visitProgramMethod(programClass, programMethod);
                    }
                    return;
                }
                ++typeCounter;
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int maxLocals = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        if (codeAttribute.u2maxLocals < maxLocals) {
            codeAttribute.u2maxLocals = maxLocals;
        }
    }

    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        String descriptor = method.getDescriptor(clazz);
        int descriptorIndex = descriptor.indexOf(41);
        String signature = signatureAttribute.getSignature(clazz);
        int signatureIndex = signature.indexOf(41);
        String newSignature = signature.substring(0, signatureIndex) + descriptor.charAt(descriptorIndex - 1) + signature.substring(signatureIndex);
        signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int oldParametersCount = parameterAnnotationsAttribute.u1parametersCount++;
        if (parameterAnnotationsAttribute.u2parameterAnnotationsCount == null || parameterAnnotationsAttribute.u2parameterAnnotationsCount.length < parameterAnnotationsAttribute.u1parametersCount) {
            int[] annotationsCounts = new int[parameterAnnotationsAttribute.u1parametersCount];
            Annotation[][] annotations = new Annotation[parameterAnnotationsAttribute.u1parametersCount][];
            System.arraycopy(parameterAnnotationsAttribute.u2parameterAnnotationsCount, 0, annotationsCounts, 0, oldParametersCount);
            System.arraycopy(parameterAnnotationsAttribute.parameterAnnotations, 0, annotations, 0, oldParametersCount);
            parameterAnnotationsAttribute.u2parameterAnnotationsCount = annotationsCounts;
            parameterAnnotationsAttribute.parameterAnnotations = annotations;
        }
    }
}

