/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.StringMatcher;

public class VariableStringMatcher
extends StringMatcher {
    private final char[] allowedCharacters;
    private final char[] disallowedCharacters;
    private final int minimumLength;
    private final int maximumLength;
    private final StringMatcher nextMatcher;

    public VariableStringMatcher(char[] allowedCharacters, char[] disallowedCharacters, int minimumLength, int maximumLength, StringMatcher nextMatcher) {
        this.allowedCharacters = allowedCharacters;
        this.disallowedCharacters = disallowedCharacters;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.nextMatcher = nextMatcher;
    }

    protected boolean matches(String string, int offset, int length) {
        if (length < this.minimumLength) {
            return false;
        }
        for (int index = offset; index < offset + this.minimumLength; ++index) {
            if (this.isAllowedCharacter(string.charAt(index))) continue;
            return false;
        }
        int maximumLength = Math.min(this.maximumLength, length);
        for (int index = offset + this.minimumLength; index < offset + maximumLength; ++index) {
            if (this.nextMatcher.matches(string, index, length + offset - index)) {
                return true;
            }
            if (this.isAllowedCharacter(string.charAt(index))) continue;
            return false;
        }
        return this.nextMatcher.matches(string, offset + maximumLength, length - maximumLength);
    }

    private boolean isAllowedCharacter(char character) {
        if (this.allowedCharacters != null) {
            for (int index = 0; index < this.allowedCharacters.length; ++index) {
                if (this.allowedCharacters[index] != character) continue;
                return true;
            }
            return false;
        }
        if (this.disallowedCharacters != null) {
            for (int index = 0; index < this.disallowedCharacters.length; ++index) {
                if (this.disallowedCharacters[index] != character) continue;
                return false;
            }
        }
        return true;
    }
}

