/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.editor.NamedAttributeDeleter;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessFlagSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.util.StringTransformer;

public class DefaultInterfaceMethodConverter
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor {
    private final ClassVisitor modifiedClassVisitor;
    private final MemberVisitor extraMemberVisitor;
    private final Set<Clazz> implClasses = new LinkedHashSet<Clazz>();
    private boolean hasDefaultMethods;

    public DefaultInterfaceMethodConverter(ClassVisitor modifiedClassVisitor, MemberVisitor extraMemberVisitor) {
        this.modifiedClassVisitor = modifiedClassVisitor;
        this.extraMemberVisitor = extraMemberVisitor;
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.hasDefaultMethods = false;
        this.implClasses.clear();
        programClass.hierarchyAccept(false, false, false, true, new ProgramClassFilter(new ClassAccessFilter(0, 512, new ClassCollector(this.implClasses))));
        programClass.accept(new AllMethodVisitor(new MemberAccessFilter(0, 8, new AllAttributeVisitor(this))));
        if (this.hasDefaultMethods) {
            programClass.accept(new ConstantPoolShrinker());
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.hasDefaultMethods = true;
        ProgramClass interfaceClass = (ProgramClass)clazz;
        ProgramMethod defaultMethod = (ProgramMethod)method;
        for (Clazz implClass : this.implClasses) {
            ProgramClass targetClass = (ProgramClass)implClass;
            if (!this.hasInheritedMethod(targetClass, defaultMethod.getName(interfaceClass), defaultMethod.getDescriptor(interfaceClass))) {
                defaultMethod.accept(interfaceClass, (MemberVisitor)new MemberAdder(targetClass));
                targetClass.accept(this.modifiedClassVisitor);
            }
            if (!this.callsDefaultMethodUsingSuper(targetClass, interfaceClass, defaultMethod)) continue;
            this.replaceDefaultMethodInvocation(targetClass, interfaceClass, defaultMethod);
            targetClass.accept(this.modifiedClassVisitor);
        }
        defaultMethod.accept(interfaceClass, (MemberVisitor)new MultiMemberVisitor(new NamedAttributeDeleter("Code"), new MemberAccessFlagSetter(1024)));
        if (this.extraMemberVisitor != null) {
            defaultMethod.accept(interfaceClass, this.extraMemberVisitor);
        }
    }

    private boolean hasInheritedMethod(Clazz clazz, String methodName, String methodDescriptor) {
        MemberCounter counter = new MemberCounter();
        clazz.hierarchyAccept(true, true, false, false, new NamedMethodVisitor(methodName, methodDescriptor, counter));
        return counter.getCount() > 0;
    }

    private boolean callsDefaultMethodUsingSuper(Clazz clazz, Clazz interfaceClass, Method defaultMethod) {
        final AtomicBoolean foundInvocation = new AtomicBoolean(false);
        clazz.accept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new SuperInvocationInstructionMatcher(interfaceClass, defaultMethod){

            public void superInvocation(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, CodeAttributeEditor codeAttributeEditor) {
                foundInvocation.set(true);
            }
        }))));
        return foundInvocation.get();
    }

    private void replaceDefaultMethodInvocation(ProgramClass targetClass, ProgramClass interfaceClass, ProgramMethod interfaceMethod) {
        StringTransformer memberRenamer = new StringTransformer(){

            public String transform(String string) {
                return "default$" + string;
            }
        };
        interfaceMethod.accept(interfaceClass, (MemberVisitor)new MemberAdder(targetClass, memberRenamer, null));
        String targetMethodName = memberRenamer.transform(interfaceMethod.getName(interfaceClass));
        String descriptor = interfaceMethod.getDescriptor(interfaceClass);
        Method targetMethod = targetClass.findMethod(targetMethodName, descriptor);
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(targetClass);
        final int constantIndex = constantPoolEditor.addMethodrefConstant(targetClass, targetMethod);
        targetClass.accept(new AllMethodVisitor(new AllAttributeVisitor(new SuperInvocationInstructionMatcher(interfaceClass, interfaceMethod){

            public void superInvocation(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, CodeAttributeEditor codeAttributeEditor) {
                ConstantInstruction instruction = new ConstantInstruction(-74, constantIndex);
                codeAttributeEditor.replaceInstruction(offset, instruction);
            }
        })));
    }

    private static class SuperInvocationInstructionMatcher
    extends SimplifiedVisitor
    implements AttributeVisitor,
    InstructionVisitor,
    ConstantVisitor {
        private final Clazz referencedClass;
        private final Method referencedMethod;
        private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        private boolean matchingInvocation;

        public SuperInvocationInstructionMatcher(Clazz referencedClass, Method referencedMethod) {
            this.referencedClass = referencedClass;
            this.referencedMethod = referencedMethod;
        }

        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            codeAttribute.instructionsAccept(clazz, method, this);
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -73: {
                    this.matchingInvocation = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    if (!this.matchingInvocation) break;
                    this.superInvocation(clazz, method, codeAttribute, offset, this.codeAttributeEditor);
                }
            }
        }

        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
            if (interfaceMethodrefConstant.referencedClass == this.referencedClass && interfaceMethodrefConstant.referencedMember == this.referencedMethod) {
                this.matchingInvocation = true;
            }
        }

        public void superInvocation(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, CodeAttributeEditor codeAttributeEditor) {
        }
    }
}

