/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class SignatureAttribute
extends Attribute {
    public int u2signatureIndex;
    public Clazz[] referencedClasses;

    public SignatureAttribute() {
    }

    public SignatureAttribute(int u2attributeNameIndex, int u2signatureIndex) {
        super(u2attributeNameIndex);
        this.u2signatureIndex = u2signatureIndex;
    }

    public String getSignature(Clazz clazz) {
        return clazz.getString(this.u2signatureIndex);
    }

    public void referencedClassesAccept(ClassVisitor classVisitor) {
        if (this.referencedClasses != null) {
            for (int index = 0; index < this.referencedClasses.length; ++index) {
                if (this.referencedClasses[index] == null) continue;
                this.referencedClasses[index].accept(classVisitor);
            }
        }
    }

    public void accept(Clazz clazz, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitSignatureAttribute(clazz, this);
    }

    public void accept(Clazz clazz, Field field, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitSignatureAttribute(clazz, field, this);
    }

    public void accept(Clazz clazz, Method method, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitSignatureAttribute(clazz, method, this);
    }
}

