/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class StringSharer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
AttributeVisitor {
    private String name;
    private String type;

    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.attributesAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        Clazz superClass = libraryClass.superClass;
        if (superClass != null) {
            libraryClass.superClassName = superClass.getName();
        }
        if (libraryClass.interfaceNames != null) {
            String[] interfaceNames = libraryClass.interfaceNames;
            Clazz[] interfaceClasses = new Clazz[interfaceNames.length];
            for (int index = 0; index < interfaceNames.length; ++index) {
                Clazz interfaceClass = interfaceClasses[index];
                if (interfaceClass == null) continue;
                interfaceNames[index] = interfaceClass.getName();
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Member referencedMember = stringConstant.referencedMember;
        if (referencedMember != null) {
            Clazz referencedClass = stringConstant.referencedClass;
            this.name = referencedMember.getName(referencedClass);
            clazz.constantPoolEntryAccept(stringConstant.u2stringIndex, this);
        }
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        Member referencedMember = refConstant.referencedMember;
        if (referencedMember != null) {
            Clazz referencedClass = refConstant.referencedClass;
            this.name = referencedMember.getName(referencedClass);
            this.type = referencedMember.getDescriptor(referencedClass);
            clazz.constantPoolEntryAccept(refConstant.u2nameAndTypeIndex, this);
        }
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        if (this.name != null) {
            clazz.constantPoolEntryAccept(nameAndTypeConstant.u2nameIndex, this);
            this.name = this.type;
            clazz.constantPoolEntryAccept(nameAndTypeConstant.u2descriptorIndex, this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        Clazz referencedClass = classConstant.referencedClass;
        if (referencedClass != null) {
            this.name = referencedClass.getName();
            clazz.constantPoolEntryAccept(classConstant.u2nameIndex, this);
        }
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (this.name != null) {
            if (this.name.equals(utf8Constant.getString())) {
                utf8Constant.setString(this.name);
            }
            this.name = null;
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        this.name = attribute.getAttributeName(clazz).intern();
        clazz.constantPoolEntryAccept(attribute.u2attributeNameIndex, this);
    }
}

