/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.OptimizedClassConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizedTypeAdapterFactoryInitializer
extends SimplifiedVisitor
implements InstructionVisitor {
    private final ClassPool programClassPool;
    private final CodeAttributeEditor codeAttributeEditor;
    private final Map<String, String> typeAdapterRegistry;
    private final GsonRuntimeSettings gsonRuntimeSettings;

    public OptimizedTypeAdapterFactoryInitializer(ClassPool programClassPool, CodeAttributeEditor codeAttributeEditor, Map<String, String> typeAdapterRegistry, GsonRuntimeSettings gsonRuntimeSettings) {
        this.programClassPool = programClassPool;
        this.codeAttributeEditor = codeAttributeEditor;
        this.typeAdapterRegistry = typeAdapterRegistry;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (method.getName(clazz).equals("create") && method.getDescriptor(clazz).equals("(Lcom/google/gson/Gson;Lcom/google/gson/reflect/TypeToken;)Lcom/google/gson/TypeAdapter;") && instruction.actualOpcode() == 1) {
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder((ProgramClass)clazz);
            CodeAttributeEditor.Label end = this.codeAttributeEditor.label();
            if (this.gsonRuntimeSettings.setFieldNamingPolicy || this.gsonRuntimeSettings.setFieldNamingStrategy) {
                ____.aload_1().getfield("com/google/gson/Gson", "fieldNamingStrategy", "Lcom/google/gson/FieldNamingStrategy;").getstatic("com/google/gson/FieldNamingPolicy", "IDENTITY", "Lcom/google/gson/FieldNamingPolicy;").ifacmpne(end.offset());
            }
            if (this.gsonRuntimeSettings.excludeFieldsWithModifiers) {
                ____.aload_1().getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "modifiers", "I").ldc(136).ificmpne(end.offset());
            }
            if (this.gsonRuntimeSettings.setExclusionStrategies || this.gsonRuntimeSettings.addSerializationExclusionStrategy || this.gsonRuntimeSettings.addDeserializationExclusionStrategy) {
                ____.aload_1().getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "serializationStrategies", "Ljava/util/List;").invokevirtual("java/util/List", "isEmpty", "()Z").ifeq(end.offset());
                ____.aload_1().getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "deserializationStrategies", "Ljava/util/List;").invokevirtual("java/util/List", "isEmpty", "()Z").ifeq(end.offset());
            }
            if (this.gsonRuntimeSettings.setVersion) {
                ____.aload_1().getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "version", "D").ldc2_w(-1.0).dcmpg().ifne(end.offset());
            }
            for (Map.Entry<String, String> typeAdapterRegistryEntry : this.typeAdapterRegistry.entrySet()) {
                String objectType = typeAdapterRegistryEntry.getKey();
                String adapterType = typeAdapterRegistryEntry.getValue();
                Clazz objectClazz = this.programClassPool.getClass(objectType);
                CodeAttributeEditor.Label elseif = this.codeAttributeEditor.label();
                ____.aload_2().invokevirtual("com/google/gson/reflect/TypeToken", "getRawType", "()Ljava/lang/Class;").ldc(objectClazz).ifacmpne(elseif.offset()).new_(adapterType).dup().aload_1().getstatic(clazz.getName(), "optimizedJsonReaderImpl", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_READER_IMPL).getstatic(clazz.getName(), "optimizedJsonWriterImpl", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_WRITER_IMPL).invokespecial(adapterType, "<init>", OptimizedClassConstants.METHOD_TYPE_INIT).areturn().label(elseif);
            }
            ____.label(end).aconst_null();
            this.codeAttributeEditor.replaceInstruction(offset, ____.instructions());
        }
    }
}

