/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.shrink.AnnotationUsageMarker;
import proguard.shrink.ClassShrinker;
import proguard.shrink.InnerUsageMarker;
import proguard.shrink.InterfaceUsageMarker;
import proguard.shrink.LocalVariableTypeUsageMarker;
import proguard.shrink.ShortestUsageMarker;
import proguard.shrink.ShortestUsagePrinter;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFilter;
import proguard.util.PrintWriterUtil;

public class Shrinker {
    private final Configuration configuration;

    public Shrinker(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPool execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        PrintWriter out = new PrintWriter(System.out, true);
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        UsageMarker usageMarker = this.configuration.whyAreYouKeeping == null ? new UsageMarker() : new ShortestUsageMarker();
        MultiClassVisitor classUsageMarker = new MultiClassVisitor(usageMarker, new NamedMethodVisitor("<init>", "()V", usageMarker));
        ClassPoolVisitor classPoolvisitor = new KeepClassSpecificationVisitorFactory(true, false, false).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)classUsageMarker, (MemberVisitor)usageMarker, (MemberVisitor)usageMarker, (AttributeVisitor)usageMarker);
        programClassPool.accept(classPoolvisitor);
        libraryClassPool.accept(classPoolvisitor);
        libraryClassPool.classesAccept(usageMarker);
        programClassPool.classesAccept(new UsedClassFilter(usageMarker, new AllAttributeVisitor(true, new MultiAttributeVisitor(new InnerUsageMarker(usageMarker), new AnnotationUsageMarker(usageMarker), new LocalVariableTypeUsageMarker(usageMarker)))));
        programClassPool.classesAccept(new InterfaceUsageMarker(usageMarker));
        if (this.configuration.whyAreYouKeeping != null) {
            out.println();
            ShortestUsagePrinter shortestUsagePrinter = new ShortestUsagePrinter((ShortestUsageMarker)usageMarker, this.configuration.verbose, out);
            ClassPoolVisitor whyClassPoolvisitor = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.whyAreYouKeeping, shortestUsagePrinter, shortestUsagePrinter, shortestUsagePrinter, null);
            programClassPool.accept(whyClassPoolvisitor);
            libraryClassPool.accept(whyClassPoolvisitor);
        }
        if (this.configuration.printUsage != null) {
            PrintWriter usageWriter = PrintWriterUtil.createPrintWriterOut(this.configuration.printUsage);
            try {
                programClassPool.classesAcceptAlphabetically(new UsagePrinter(usageMarker, true, usageWriter));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printUsage, usageWriter);
            }
        }
        int originalProgramClassPoolSize = programClassPool.size();
        ClassPool newProgramClassPool = new ClassPool();
        programClassPool.classesAccept(new UsedClassFilter(usageMarker, new MultiClassVisitor(new ClassShrinker(usageMarker), new ClassPoolFiller(newProgramClassPool))));
        programClassPool.clear();
        libraryClassPool.classesAccept(new ClassShrinker(usageMarker));
        int newProgramClassPoolSize = newProgramClassPool.size();
        if (this.configuration.verbose) {
            out.println("Removing unused program classes and class elements...");
            out.println("  Original number of program classes: " + originalProgramClassPoolSize);
            out.println("  Final number of program classes:    " + newProgramClassPoolSize);
        }
        if (!(newProgramClassPoolSize != 0 || this.configuration.warn != null && this.configuration.warn.isEmpty())) {
            if (this.configuration.ignoreWarnings) {
                System.err.println("Warning: the output jar is empty. Did you specify the proper '-keep' options?");
            } else {
                throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
            }
        }
        return newProgramClassPool;
    }
}

