/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;

@NotThreadSafe
public final class BlueprintSession {
    private static final String SEPARATOR = "->";
    private final Stack<Class<?>> stack = new Stack();
    private final Set<Class<?>> classes = new HashSet();
    private int blueprintCount = 0;
    private String lastAction = "";

    private boolean detectCycles(@Nonnull Class<?> clazz) {
        return this.stack.contains(clazz);
    }

    public Set<Class<?>> getBlueprintClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    public int getBlueprintCount() {
        return this.blueprintCount;
    }

    public String getContext() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.stack.size(); ++i) {
            buffer.append(((Class)this.stack.get(i)).getName());
            if (i >= this.stack.size() - 1) continue;
            buffer.append(SEPARATOR);
        }
        if (!this.lastAction.isEmpty()) {
            buffer.append(" {");
            buffer.append(this.lastAction);
            buffer.append('}');
        }
        return buffer.toString();
    }

    public void pop() {
        this.stack.pop();
        ++this.blueprintCount;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public boolean push(@Nonnull Class<?> clazz) {
        Check.notNull(clazz, (String)"clazz");
        boolean cycle = this.detectCycles(clazz);
        this.stack.push(clazz);
        this.classes.add(clazz);
        return cycle;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public void setLastAction(@Nonnull String lastAction) {
        this.lastAction = (String)Check.notEmpty((CharSequence)lastAction, (String)"lastAction");
    }
}

