/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.BattleResults;
import robocode.Event;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicEvents2;
import robocode.robotinterfaces.IBasicRobot;

public final class BattleEndedEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 100;
    private final boolean aborted;
    private final BattleResults results;

    public BattleEndedEvent(boolean aborted, BattleResults results) {
        this.aborted = aborted;
        this.results = results;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public BattleResults getResults() {
        return this.results;
    }

    @Override
    final int getDefaultPriority() {
        return 100;
    }

    @Override
    public final int getPriority() {
        return 100;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IBasicEvents listener;
        if (robot != null && (listener = robot.getBasicEventListener()) != null && IBasicEvents2.class.isAssignableFrom(listener.getClass())) {
            ((IBasicEvents2)listener).onBattleEnded(this);
        }
    }

    @Override
    final boolean isCriticalEvent() {
        return true;
    }

    @Override
    byte getSerializationType() {
        return 32;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            BattleEndedEvent obj = (BattleEndedEvent)object;
            return 2 + serializer.sizeOf((byte)8, obj.results);
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            BattleEndedEvent obj = (BattleEndedEvent)object;
            serializer.serialize(buffer, obj.aborted);
            serializer.serialize(buffer, (byte)8, (Object)obj.results);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            boolean aborted = serializer.deserializeBoolean(buffer);
            BattleResults results = (BattleResults)serializer.deserializeAny(buffer);
            return new BattleEndedEvent(aborted, results);
        }
    }
}

