/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;

public class BattleResults
implements Serializable,
Comparable<BattleResults> {
    protected static final long serialVersionUID = 1L;
    protected String teamLeaderName;
    protected int rank;
    protected double score;
    protected double survival;
    protected double lastSurvivorBonus;
    protected double bulletDamage;
    protected double bulletDamageBonus;
    protected double ramDamage;
    protected double ramDamageBonus;
    protected int firsts;
    protected int seconds;
    protected int thirds;

    public BattleResults(String teamLeaderName, int rank, double score, double survival, double lastSurvivorBonus, double bulletDamage, double bulletDamageBonus, double ramDamage, double ramDamageBonus, int firsts, int seconds, int thirds) {
        this.teamLeaderName = teamLeaderName;
        this.rank = rank;
        this.score = score;
        this.survival = survival;
        this.lastSurvivorBonus = lastSurvivorBonus;
        this.bulletDamage = bulletDamage;
        this.bulletDamageBonus = bulletDamageBonus;
        this.ramDamage = ramDamage;
        this.ramDamageBonus = ramDamageBonus;
        this.firsts = firsts;
        this.seconds = seconds;
        this.thirds = thirds;
    }

    public String getTeamLeaderName() {
        return this.teamLeaderName;
    }

    public int getRank() {
        return this.rank;
    }

    public int getScore() {
        return (int)(this.score + 0.5);
    }

    public int getSurvival() {
        return (int)(this.survival + 0.5);
    }

    public int getLastSurvivorBonus() {
        return (int)(this.lastSurvivorBonus + 0.5);
    }

    public int getBulletDamage() {
        return (int)(this.bulletDamage + 0.5);
    }

    public int getBulletDamageBonus() {
        return (int)(this.bulletDamageBonus + 0.5);
    }

    public int getRamDamage() {
        return (int)(this.ramDamage + 0.5);
    }

    public int getRamDamageBonus() {
        return (int)(this.ramDamageBonus + 0.5);
    }

    public int getFirsts() {
        return this.firsts;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getThirds() {
        return this.thirds;
    }

    @Override
    public int compareTo(BattleResults o) {
        return Double.valueOf(this.score).compareTo(o.score);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BattleResults other = (BattleResults)obj;
        return Double.doubleToLongBits(this.score) == Double.doubleToLongBits(other.score);
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            BattleResults obj = (BattleResults)object;
            return 1 + serializer.sizeOf(obj.teamLeaderName) + 16 + 56;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            BattleResults obj = (BattleResults)object;
            serializer.serialize(buffer, obj.teamLeaderName);
            serializer.serialize(buffer, obj.rank);
            serializer.serialize(buffer, obj.score);
            serializer.serialize(buffer, obj.survival);
            serializer.serialize(buffer, obj.lastSurvivorBonus);
            serializer.serialize(buffer, obj.bulletDamage);
            serializer.serialize(buffer, obj.bulletDamageBonus);
            serializer.serialize(buffer, obj.ramDamage);
            serializer.serialize(buffer, obj.ramDamageBonus);
            serializer.serialize(buffer, obj.firsts);
            serializer.serialize(buffer, obj.seconds);
            serializer.serialize(buffer, obj.thirds);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            String teamLeaderName = serializer.deserializeString(buffer);
            int rank = buffer.getInt();
            double score = buffer.getDouble();
            double survival = buffer.getDouble();
            double lastSurvivorBonus = buffer.getDouble();
            double bulletDamage = buffer.getDouble();
            double bulletDamageBonus = buffer.getDouble();
            double ramDamage = buffer.getDouble();
            double ramDamageBonus = buffer.getDouble();
            int firsts = buffer.getInt();
            int seconds = buffer.getInt();
            int thirds = buffer.getInt();
            return new BattleResults(teamLeaderName, rank, score, survival, lastSurvivorBonus, bulletDamage, bulletDamageBonus, ramDamage, ramDamageBonus, firsts, seconds, thirds);
        }
    }
}

