/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.robocode.security.IHiddenBulletHelper;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Rules;

public class Bullet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double headingRadians;
    private double x;
    private double y;
    private final double power;
    private final String ownerName;
    private String victimName;
    private boolean isActive;
    private final int bulletId;

    public Bullet(double heading, double x, double y, double power, String ownerName, String victimName, boolean isActive, int bulletId) {
        this.headingRadians = heading;
        this.x = x;
        this.y = y;
        this.power = power;
        this.ownerName = ownerName;
        this.victimName = victimName;
        this.isActive = isActive;
        this.bulletId = bulletId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.bulletId == ((Bullet)obj).bulletId;
    }

    public int hashCode() {
        return this.bulletId;
    }

    public double getHeading() {
        return Math.toDegrees(this.headingRadians);
    }

    public double getHeadingRadians() {
        return this.headingRadians;
    }

    public String getName() {
        return this.ownerName;
    }

    public double getPower() {
        return this.power;
    }

    public double getVelocity() {
        return Rules.getBulletSpeed(this.power);
    }

    public String getVictim() {
        return this.victimName;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void update(double x, double y, String victimName, boolean isActive) {
        this.x = x;
        this.y = y;
        this.victimName = victimName;
        this.isActive = isActive;
    }

    int getBulletId() {
        return this.bulletId;
    }

    static IHiddenBulletHelper createHiddenHelper() {
        return new HiddenBulletHelper();
    }

    static ISerializableHelper createHiddenSerializer() {
        return new HiddenBulletHelper();
    }

    private static class HiddenBulletHelper
    implements IHiddenBulletHelper,
    ISerializableHelper {
        private HiddenBulletHelper() {
        }

        @Override
        public void update(Bullet bullet, double x, double y, String victimName, boolean isActive) {
            bullet.update(x, y, victimName, isActive);
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            Bullet obj = (Bullet)object;
            return 33 + serializer.sizeOf(obj.ownerName) + serializer.sizeOf(obj.victimName) + 1 + 4;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            Bullet obj = (Bullet)object;
            serializer.serialize(buffer, obj.headingRadians);
            serializer.serialize(buffer, obj.x);
            serializer.serialize(buffer, obj.y);
            serializer.serialize(buffer, obj.power);
            serializer.serialize(buffer, obj.ownerName);
            serializer.serialize(buffer, obj.victimName);
            serializer.serialize(buffer, obj.isActive);
            serializer.serialize(buffer, obj.bulletId);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            double headingRadians = buffer.getDouble();
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            double power = buffer.getDouble();
            String ownerName = serializer.deserializeString(buffer);
            String victimName = serializer.deserializeString(buffer);
            boolean isActive = serializer.deserializeBoolean(buffer);
            int bulletId = serializer.deserializeInt(buffer);
            return new Bullet(headingRadians, x, y, power, ownerName, victimName, isActive, bulletId);
        }
    }
}

