/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Bullet;
import robocode.Event;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicRobot;

public final class BulletHitBulletEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 55;
    private Bullet bullet;
    private final Bullet hitBullet;

    public BulletHitBulletEvent(Bullet bullet, Bullet hitBullet) {
        this.bullet = bullet;
        this.hitBullet = hitBullet;
    }

    public Bullet getBullet() {
        return this.bullet;
    }

    public Bullet getHitBullet() {
        return this.hitBullet;
    }

    @Override
    final int getDefaultPriority() {
        return 55;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IBasicEvents listener = robot.getBasicEventListener();
        if (listener != null) {
            listener.onBulletHitBullet(this);
        }
    }

    @Override
    byte getSerializationType() {
        return 33;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            BulletHitBulletEvent obj = (BulletHitBulletEvent)object;
            return 5 + serializer.sizeOf((byte)9, obj.hitBullet);
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            BulletHitBulletEvent obj = (BulletHitBulletEvent)object;
            serializer.serialize(buffer, obj.bullet.getBulletId());
            serializer.serialize(buffer, (byte)9, (Object)obj.hitBullet);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            Bullet bullet = new Bullet(0.0, 0.0, 0.0, 0.0, null, null, false, buffer.getInt());
            Bullet hitBullet = (Bullet)serializer.deserializeAny(buffer);
            return new BulletHitBulletEvent(bullet, hitBullet);
        }
    }
}

