/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Bullet;
import robocode.Event;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicRobot;

public final class BulletHitEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 50;
    private final String name;
    private final double energy;
    private Bullet bullet;

    public BulletHitEvent(String name, double energy, Bullet bullet) {
        this.name = name;
        this.energy = energy;
        this.bullet = bullet;
    }

    public Bullet getBullet() {
        return this.bullet;
    }

    public double getEnergy() {
        return this.energy;
    }

    @Deprecated
    public double getLife() {
        return this.energy;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public double getRobotLife() {
        return this.energy;
    }

    @Deprecated
    public String getRobotName() {
        return this.name;
    }

    @Override
    final int getDefaultPriority() {
        return 50;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IBasicEvents listener = robot.getBasicEventListener();
        if (listener != null) {
            listener.onBulletHit(this);
        }
    }

    @Override
    byte getSerializationType() {
        return 34;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            BulletHitEvent obj = (BulletHitEvent)object;
            return 5 + serializer.sizeOf(obj.name) + 8;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            BulletHitEvent obj = (BulletHitEvent)object;
            serializer.serialize(buffer, obj.bullet.getBulletId());
            serializer.serialize(buffer, obj.name);
            serializer.serialize(buffer, obj.energy);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            Bullet bullet = new Bullet(0.0, 0.0, 0.0, 0.0, null, null, false, buffer.getInt());
            String name = serializer.deserializeString(buffer);
            double energy = buffer.getDouble();
            return new BulletHitEvent(name, energy, bullet);
        }
    }
}

