/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import net.sf.robocode.peer.IRobotStatics;
import robocode.Condition;
import robocode.Event;
import robocode.robotinterfaces.IAdvancedEvents;
import robocode.robotinterfaces.IAdvancedRobot;
import robocode.robotinterfaces.IBasicRobot;

public class CustomEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 80;
    private final transient Condition condition;

    public CustomEvent(Condition condition) {
        this.condition = condition;
        if (condition != null) {
            this.setPriority(condition.getPriority());
        }
    }

    public CustomEvent(Condition condition, int priority) {
        this.condition = condition;
        this.setPriority(priority);
        if (condition != null) {
            condition.setPriority(this.getPriority());
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    @Override
    final int getDefaultPriority() {
        return 80;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IAdvancedEvents listener;
        if (statics.isAdvancedRobot() && (listener = ((IAdvancedRobot)robot).getAdvancedEventListener()) != null) {
            listener.onCustomEvent(this);
        }
    }

    @Override
    public final int compareTo(Event event) {
        return super.compareTo(event);
    }

    @Override
    final boolean isCriticalEvent() {
        return false;
    }

    @Override
    public final int getPriority() {
        return super.getPriority();
    }

    @Override
    byte getSerializationType() {
        throw new Error("Serialization not supported on this event type");
    }
}

