/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Bullet;
import robocode.Event;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicRobot;

public final class HitByBulletEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 20;
    private final double bearing;
    private final Bullet bullet;

    public HitByBulletEvent(double bearing, Bullet bullet) {
        this.bearing = bearing;
        this.bullet = bullet;
    }

    public double getBearing() {
        return this.bearing * 180.0 / Math.PI;
    }

    public double getBearingRadians() {
        return this.bearing;
    }

    public Bullet getBullet() {
        return this.bullet;
    }

    public double getHeading() {
        return this.bullet.getHeading();
    }

    @Deprecated
    public double getHeadingDegrees() {
        return this.getHeading();
    }

    public double getHeadingRadians() {
        return this.bullet.getHeadingRadians();
    }

    public String getName() {
        return this.bullet.getName();
    }

    public double getPower() {
        return this.bullet.getPower();
    }

    public double getVelocity() {
        return this.bullet.getVelocity();
    }

    @Override
    final int getDefaultPriority() {
        return 20;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IBasicEvents listener = robot.getBasicEventListener();
        if (listener != null) {
            listener.onHitByBullet(this);
        }
    }

    @Override
    byte getSerializationType() {
        return 42;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            HitByBulletEvent obj = (HitByBulletEvent)object;
            return 1 + serializer.sizeOf((byte)9, obj.bullet) + 8;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            HitByBulletEvent obj = (HitByBulletEvent)object;
            serializer.serialize(buffer, (byte)9, (Object)obj.bullet);
            serializer.serialize(buffer, obj.bearing);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            Bullet bullet = (Bullet)serializer.deserializeAny(buffer);
            double bearing = buffer.getDouble();
            return new HitByBulletEvent(bearing, bullet);
        }
    }
}

