/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Event;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicRobot;

public final class HitRobotEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 40;
    private final String robotName;
    private final double bearing;
    private final double energy;
    private final boolean atFault;

    public HitRobotEvent(String name, double bearing, double energy, boolean atFault) {
        this.robotName = name;
        this.bearing = bearing;
        this.energy = energy;
        this.atFault = atFault;
    }

    public double getBearing() {
        return this.bearing * 180.0 / Math.PI;
    }

    @Deprecated
    public double getBearingDegrees() {
        return this.getBearing();
    }

    public double getBearingRadians() {
        return this.bearing;
    }

    public double getEnergy() {
        return this.energy;
    }

    public String getName() {
        return this.robotName;
    }

    @Deprecated
    public String getRobotName() {
        return this.robotName;
    }

    public boolean isMyFault() {
        return this.atFault;
    }

    @Override
    public final int compareTo(Event event) {
        int res = super.compareTo(event);
        if (res != 0) {
            return res;
        }
        if (event instanceof HitRobotEvent) {
            int compare1 = this.isMyFault() ? -1 : 0;
            int compare2 = ((HitRobotEvent)event).isMyFault() ? -1 : 0;
            return compare1 - compare2;
        }
        return 0;
    }

    @Override
    final int getDefaultPriority() {
        return 40;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IBasicEvents listener = robot.getBasicEventListener();
        if (listener != null) {
            listener.onHitRobot(this);
        }
    }

    @Override
    byte getSerializationType() {
        return 43;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            HitRobotEvent obj = (HitRobotEvent)object;
            return 1 + serializer.sizeOf(obj.robotName) + 16 + 1;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            HitRobotEvent obj = (HitRobotEvent)object;
            serializer.serialize(buffer, obj.robotName);
            serializer.serialize(buffer, obj.bearing);
            serializer.serialize(buffer, obj.energy);
            serializer.serialize(buffer, obj.atFault);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            String robotName = serializer.deserializeString(buffer);
            double bearing = buffer.getDouble();
            double energy = buffer.getDouble();
            boolean atFault = serializer.deserializeBoolean(buffer);
            return new HitRobotEvent(robotName, bearing, energy, atFault);
        }
    }
}

