/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Event;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicRobot;

public final class HitWallEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 30;
    private final double bearing;

    public HitWallEvent(double bearing) {
        this.bearing = bearing;
    }

    public double getBearing() {
        return this.bearing * 180.0 / Math.PI;
    }

    @Deprecated
    public double getBearingDegrees() {
        return this.getBearing();
    }

    public double getBearingRadians() {
        return this.bearing;
    }

    @Override
    final int getDefaultPriority() {
        return 30;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IBasicEvents listener = robot.getBasicEventListener();
        if (listener != null) {
            listener.onHitWall(this);
        }
    }

    @Override
    byte getSerializationType() {
        return 38;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            return 9;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            HitWallEvent obj = (HitWallEvent)object;
            serializer.serialize(buffer, obj.bearing);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            double bearing = buffer.getDouble();
            return new HitWallEvent(bearing);
        }
    }
}

